/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.socket.requests;

import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.request.PublishEvent;
import com.liveperson.api.response.model.DeliveryStatusUpdateInfo;
import com.liveperson.api.response.types.DeliveryStatus;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class DeliveryStatusUpdateRequest
extends BaseAMSSocketRequest<PublishEvent.Response, DeliveryStatusUpdateRequest> {
    private static final String TAG = DeliveryStatusUpdateRequest.class.getSimpleName();
    private String mDialogId;
    private String mConversationId;
    private DeliveryStatus status;
    private PublishEvent.Type type = PublishEvent.Type.AcceptStatusEvent;
    List<Integer> sequenceList;
    private DeliveryStatusUpdateInfo mInfo = null;

    public DeliveryStatusUpdateRequest(String socketUrl, String dialogId, String conversationId, DeliveryStatus status, List<Integer> sequenceList) {
        super(socketUrl);
        this.mDialogId = dialogId;
        this.mConversationId = conversationId;
        this.status = status;
        this.sequenceList = sequenceList;
    }

    public void setInfo(DeliveryStatusUpdateInfo info) {
        this.mInfo = info;
    }

    protected String getData() {
        int[] sequenceArray = new int[this.sequenceList.size()];
        int i = 0;
        for (Integer seq : this.sequenceList) {
            sequenceArray[i++] = seq;
        }
        return new PublishEvent(this.mDialogId, this.mConversationId, this.type, this.status.name(), sequenceArray, this.mInfo).toJsonString(this.getRequestId());
    }

    protected String getRequestName() {
        return TAG;
    }

    protected BaseResponseHandler<PublishEvent.Response, DeliveryStatusUpdateRequest> getResponseHandler() {
        return new BaseResponseHandler<PublishEvent.Response, DeliveryStatusUpdateRequest>(){

            public String getAPIResponseType() {
                return "ms.PublishEventResponse";
            }

            protected PublishEvent.Response parse(JSONObject jsonObject) throws JSONException {
                return new PublishEvent.Response(jsonObject);
            }

            protected boolean handle(PublishEvent.Response data) {
                return true;
            }
        };
    }
}

