/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.socket.requests;

import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.request.ReqBody;
import com.liveperson.api.request.UnsubscribeExConversations;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import org.json.JSONException;
import org.json.JSONObject;

public class UnSubscribeExConversationsRequest
extends BaseAMSSocketRequest<ReqBody.StringResp, UnSubscribeExConversationsRequest> {
    private static final String TAG = UnSubscribeExConversationsRequest.class.getSimpleName();
    private String mSubscriptionId;

    public UnSubscribeExConversationsRequest(String socketUrl, String subscriptionId) {
        super(socketUrl);
        this.mSubscriptionId = subscriptionId;
    }

    protected String getData() {
        return new UnsubscribeExConversations(this.mSubscriptionId).toJsonString(this.getRequestId());
    }

    protected String getRequestName() {
        return TAG;
    }

    protected BaseResponseHandler<ReqBody.StringResp, UnSubscribeExConversationsRequest> getResponseHandler() {
        return new BaseResponseHandler<ReqBody.StringResp, UnSubscribeExConversationsRequest>(){

            public String getAPIResponseType() {
                return "StringResponse";
            }

            protected ReqBody.StringResp parse(JSONObject jsonObject) throws JSONException {
                return new ReqBody.StringResp(jsonObject);
            }

            protected boolean handle(ReqBody.StringResp response) {
                if (response == null) {
                    LPMobileLog.w((String)TAG, (String)"Received response null for UnSubscribe request");
                    return true;
                }
                switch (response.code) {
                    case 200: {
                        LPMobileLog.d((String)TAG, (String)"Received response code 200");
                        break;
                    }
                    case 400: {
                        LPMobileLog.d((String)TAG, (String)"Can't un subscribe (response code 400)");
                        break;
                    }
                    default: {
                        LPMobileLog.w((String)TAG, (String)("Received response code other than 200 (" + response.code + ")."));
                    }
                }
                return true;
            }
        };
    }
}

