package com.liveperson.api.response.types;

import com.liveperson.infra.log.LPMobileLog;

import org.json.JSONObject;

/**
 * Created by shiranr on 17/07/2016.
 */
public class CSAT {

	private static final String TAG = "CSAT";

	public enum CSAT_SHOW_STATUS {
		NO_VALUE(-1), NOT_SHOWN(0), SHOWN(1), NO_NEED_TO_SHOW(2);

		private final int csatValue;

		CSAT_SHOW_STATUS(int value) {
			csatValue = value;
		}

		public int getValue() {
			return csatValue;
		}

		public static CSAT_SHOW_STATUS parse(int intValue) {
			for (CSAT_SHOW_STATUS csat : CSAT.CSAT_SHOW_STATUS.values()) {
				if (csat.csatValue == intValue) {
					return csat;
				}
			}
			return NO_VALUE;
		}
	}

	public int csatRate = -1;
	public String csatResolutionConfirmation;
	public CsatStatus csatStatus;
	private CSAT_SHOW_STATUS showedCsat = CSAT_SHOW_STATUS.NO_VALUE;

	public CSAT(JSONObject jsonObject) {

		JSONObject csatObject = jsonObject.optJSONObject("csat");
		if (csatObject != null && !jsonObject.isNull("csat")){
			csatRate = csatObject.isNull("csatRate") ? -1 : csatObject.optInt("csatRate", -1);
			csatResolutionConfirmation = csatObject.isNull("csatResolutionConfirmation") ? null : csatObject.optString("csatResolutionConfirmation", null);
			String status = csatObject.isNull("status") ? null : csatObject.optString("status", null);
			csatStatus = CsatStatus.get(status);
		}

		calculateCsatShown();

	}

	private void calculateCsatShown() {
		//notify UI we can dismiss Feedback Screen
		if(csatRate > 0 || csatStatus == CsatStatus.SKIPPED || csatResolutionConfirmation != null){
			showedCsat = CSAT_SHOW_STATUS.SHOWN;
		}else{
			showedCsat = CSAT_SHOW_STATUS.NOT_SHOWN;
		}
	}

	public CSAT_SHOW_STATUS isShowedCsat() {
		LPMobileLog.d(TAG, "CSAT state = "+ showedCsat.name());
		return showedCsat;
	}
}
