/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.request.message;

import com.liveperson.api.request.message.BasePublishMessage;
import com.liveperson.infra.log.LPMobileLog;
import org.json.JSONException;
import org.json.JSONObject;

public class FormSubmissionPublishMessage
extends BasePublishMessage {
    private static final String TAG = "FormSubmissionPublishMessage";
    private static final String INVITATION_ID = "invitationId";
    private static final String SUBMISSION_ID = "submissionId";
    private String invitationId;
    private String submissionId;
    private JSONObject jsonObject;

    public FormSubmissionPublishMessage(String invitationId, String submissionId) {
        this.invitationId = invitationId;
        this.submissionId = submissionId;
        this.jsonObject = new JSONObject();
        try {
            this.jsonObject.put(INVITATION_ID, (Object)this.invitationId);
            this.jsonObject.put(SUBMISSION_ID, (Object)this.submissionId);
        }
        catch (JSONException e) {
            LPMobileLog.e((String)TAG, (String)"JSONException while building JSON Object.", (Throwable)e);
        }
    }

    public FormSubmissionPublishMessage(JSONObject jsonObject) {
        if (jsonObject != null) {
            this.invitationId = jsonObject.optString(INVITATION_ID);
            this.submissionId = jsonObject.optString(SUBMISSION_ID);
            this.jsonObject = jsonObject;
        }
    }

    public JSONObject getMessage() {
        return this.jsonObject;
    }

    public String getInvitationId() {
        return this.invitationId;
    }

    public String getSubmissionId() {
        return this.submissionId;
    }

    @Override
    public BasePublishMessage.PublishMessageType getType() {
        return BasePublishMessage.PublishMessageType.FORM_SUBMISSION;
    }

    @Override
    public String getMessageText() {
        return this.getMessageTextWithoutSpecialChars(this.jsonObject.toString());
    }
}

