/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.response.types;

import android.text.TextUtils;
import com.liveperson.infra.log.LPMobileLog;

public enum DialogType {
    MAIN,
    POST_SURVEY,
    AGENT,
    OTHER;

    private static final String TAG;

    public static DialogType parse(int ordinal) {
        DialogType result = MAIN;
        DialogType[] values = DialogType.values();
        if (ordinal < values.length) {
            result = values[ordinal];
        }
        return result;
    }

    public static DialogType parse(String dialogTypeString) {
        DialogType result = MAIN;
        if (TextUtils.isEmpty((CharSequence)dialogTypeString)) {
            return result;
        }
        try {
            result = DialogType.valueOf(dialogTypeString);
        }
        catch (Exception e) {
            DialogType[] values;
            LPMobileLog.e((String)TAG, (String)("Failed to parse DialogType from string: " + dialogTypeString), (Throwable)e);
            for (DialogType dialogType : values = DialogType.values()) {
                if (!dialogType.name().equalsIgnoreCase(dialogTypeString)) continue;
                result = dialogType;
                break;
            }
        }
        return result;
    }

    static {
        TAG = DialogType.class.getSimpleName();
    }
}

