/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.background;

import android.net.Uri;
import com.liveperson.api.response.BaseGenerateURLResponse;
import com.liveperson.api.response.IOnUrlReady;
import com.liveperson.api.response.model.QueryParams;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.database.tables.FilesTable;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.DownloadFileTaskCallback;
import com.liveperson.messaging.background.filesharing.DownloadFileTaskBundle;
import com.liveperson.messaging.network.http.DownloadFileRequest;
import com.liveperson.messaging.network.http.IncaGetFileUrlRequest;
import com.liveperson.messaging.network.socket.requests.GetUrlForDownloadRequest;

public abstract class DownloadFileTask {
    private static final String TAG = "DownloadFileTask";
    private DownloadFileTaskCallback mDownloadFileTaskCallback;
    protected DownloadFileTaskBundle mDownloadFileTaskParams;
    private String mRelativePath;
    private FilesTable.LoadStatus mStatus = FilesTable.LoadStatus.NOT_STARTED;
    private long mFileRowId = -1L;

    protected abstract String saveFileToDisk(byte[] var1);

    public DownloadFileTask(DownloadFileTaskBundle params) {
        this.mDownloadFileTaskParams = params;
        this.mFileRowId = this.mDownloadFileTaskParams.getFileRowId();
    }

    public void startDownload(boolean fromInca) {
        if (fromInca) {
            this.getFileUrlFromInca();
        } else {
            this.getFileUrlFromUMS();
        }
    }

    private void getFileUrlFromInca() {
        this.setStatus(FilesTable.LoadStatus.REQUESTING_URL);
        String relativePath = this.mDownloadFileTaskParams.getRelativePath();
        if (relativePath != null && !relativePath.isEmpty()) {
            if (relativePath.contains("/")) {
                relativePath = relativePath.substring(relativePath.lastIndexOf("/") + 1);
            }
        } else {
            this.setStatus(FilesTable.LoadStatus.FAILED);
            return;
        }
        new IncaGetFileUrlRequest(MessagingFactory.getInstance().getController(), this.mDownloadFileTaskParams.getBrandId(), this.mDownloadFileTaskParams.getConversationId(), relativePath, new ICallback<Uri, Exception>(){

            public void onSuccess(Uri uri) {
                DownloadFileTask.this.mRelativePath = uri.getPath();
                MessagingFactory.getInstance().getController().amsFiles.updateRelativePath(DownloadFileTask.this.mFileRowId, DownloadFileTask.this.mRelativePath);
                if (DownloadFileTask.this.isDownloadFailed()) {
                    return;
                }
                QueryParams queryParams = new QueryParams(uri);
                DownloadFileTask.this.downloadFromSwift(queryParams);
            }

            public void onError(Exception exception) {
                if (DownloadFileTask.this.isDownloadFailed()) {
                    return;
                }
                DownloadFileTask.this.onDownloadFailed(new Exception("failed to generate url. " + exception.toString()));
            }
        }).execute();
    }

    public void onConnectionAvailable() {
        LPMobileLog.d((String)(TAG + Thread.currentThread()), (String)"onConnectionAvailable");
        if (this.mStatus == FilesTable.LoadStatus.NOT_STARTED) {
            this.setStatus(FilesTable.LoadStatus.PROCESSING);
            this.mDownloadFileTaskCallback.onReadyToGetUrl();
        }
    }

    public void setCallBack(DownloadFileTaskCallback downloadFileTaskCallback) {
        this.mDownloadFileTaskCallback = downloadFileTaskCallback;
    }

    private void getFileUrlFromUMS() {
        this.setStatus(FilesTable.LoadStatus.REQUESTING_URL);
        LPMobileLog.d((String)(TAG + Thread.currentThread()), (String)"generateUrlRunnable");
        SocketManager.getInstance().send((BaseSocketRequest)new GetUrlForDownloadRequest(MessagingFactory.getInstance().getController(), this.mDownloadFileTaskParams.getBrandId(), this.mDownloadFileTaskParams.getRelativePath(), new IOnUrlReady(){

            @Override
            public void onUrlReady(BaseGenerateURLResponse body) {
                LPMobileLog.d((String)(DownloadFileTask.TAG + Thread.currentThread()), (String)("URL ready!!" + body.relativePath));
                DownloadFileTask.this.mRelativePath = body.relativePath;
                MessagingFactory.getInstance().getController().amsFiles.updateRelativePath(DownloadFileTask.this.mFileRowId, DownloadFileTask.this.mRelativePath);
                if (DownloadFileTask.this.isDownloadFailed()) {
                    return;
                }
                DownloadFileTask.this.downloadFromSwift(body.queryParams);
            }

            @Override
            public void onUrlError(String errorMessage) {
                if (DownloadFileTask.this.isDownloadFailed()) {
                    return;
                }
                DownloadFileTask.this.onDownloadFailed(new Exception("failed to generate url." + errorMessage));
            }
        }));
    }

    private void downloadFromSwift(QueryParams queryParams) {
        LPMobileLog.d((String)(TAG + Thread.currentThread()), (String)"Downloading from swift..");
        this.setStatus(FilesTable.LoadStatus.DOWNLOADING);
        DownloadFileRequest mDownloadFileRequest = new DownloadFileRequest(this.mDownloadFileTaskParams.getSwiftDomain(), this.mRelativePath, queryParams, this.mDownloadFileTaskParams.getRestParams().mCertificates, new ICallback<byte[], Exception>(){

            public void onSuccess(byte[] byteArray) {
                if (DownloadFileTask.this.isDownloadFailed()) {
                    return;
                }
                LPMobileLog.d((String)(DownloadFileTask.TAG + Thread.currentThread()), (String)"Downloading from swift succeeded! saving file");
                final String path = DownloadFileTask.this.saveFileToDisk(byteArray);
                MessagingFactory.getInstance().getController().amsFiles.updateLocalPath(DownloadFileTask.this.mFileRowId, path).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Void>(){

                    public void onResult(Void data) {
                        DownloadFileTask.this.onDownloadSucceed(path);
                    }
                }).execute();
            }

            public void onError(Exception exception) {
                if (DownloadFileTask.this.isDownloadFailed()) {
                    return;
                }
                LPMobileLog.w((String)DownloadFileTask.TAG, (String)"failed to Download from swift ", (Throwable)exception);
                DownloadFileTask.this.onDownloadFailed(exception);
            }
        });
        mDownloadFileRequest.execute();
    }

    private void notifyChange() {
        MessagingFactory.getInstance().getController().amsMessages.updateFileMessageByRowId(this.mDownloadFileTaskParams.getMessageRowId(), this.mDownloadFileTaskParams.getFileRowId()).execute();
    }

    private void onDownloadSucceed(String fullImageLocalPath) {
        this.setStatus(FilesTable.LoadStatus.COMPLETED);
        if (this.mDownloadFileTaskCallback != null) {
            this.mDownloadFileTaskCallback.onDownloadFinishedSuccessfully(fullImageLocalPath);
        }
    }

    public void onConnectionUnavailable() {
        this.onDownloadFailed(new Exception("Failed to Download. connection unavailable"));
    }

    private void onDownloadFailed(Throwable exception) {
        LPMobileLog.d((String)TAG, (String)"onDownloadFailed. ", (Throwable)exception);
        this.setStatus(FilesTable.LoadStatus.FAILED);
        if (this.mDownloadFileTaskCallback != null) {
            this.mDownloadFileTaskCallback.onDownloadFailed(this, exception);
        }
    }

    public void setStatus(FilesTable.LoadStatus status) {
        this.mStatus = status;
        LPMobileLog.d((String)(TAG + Thread.currentThread()), (String)("set file status: " + status + " mFileRowId = " + this.mFileRowId));
        if (this.mFileRowId != -1L) {
            MessagingFactory.getInstance().getController().amsFiles.updateStatus(this.mFileRowId, this.mStatus);
        }
        this.notifyChange();
    }

    public boolean isDownloadCompleted() {
        return this.mStatus == FilesTable.LoadStatus.COMPLETED;
    }

    public boolean isDownloadFailed() {
        return this.mStatus == FilesTable.LoadStatus.FAILED;
    }
}

