/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.background.filesharing;

import com.liveperson.api.response.BaseGenerateURLResponse;
import com.liveperson.api.response.IOnUrlReady;
import com.liveperson.api.response.model.QueryParams;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.database.tables.FilesTable;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.UploadFileTaskCallback;
import com.liveperson.messaging.background.filesharing.UploadFileTaskBundle;
import com.liveperson.messaging.commands.SendFileCommand;
import com.liveperson.messaging.network.http.UploadFileRequest;
import com.liveperson.messaging.network.socket.requests.GetUrlForUploadRequest;

public abstract class BaseUploadTask {
    public static final String TAG = "BaseUploadTask";
    protected SendFileCommand sendMessageCommand;
    protected long mFileRowId = -1L;
    protected long mMessageRowId = -1L;
    protected FilesTable.LoadStatus mStatus = FilesTable.LoadStatus.NOT_STARTED;
    protected String mRelativePath;
    protected byte[] mOriginalFileByteArray = null;
    private UploadFileTaskCallback mUploadFileTaskCallback;
    protected int mUploadTimeout = 30000;

    protected abstract UploadFileTaskBundle getUploadTaskBundle();

    protected abstract byte[] getFileByteArray();

    public abstract int getTaskId();

    public abstract String getThumbnailBase64();

    public BaseUploadTask(Integer uploadTimeout) {
        if (uploadTimeout != null) {
            this.mUploadTimeout = uploadTimeout;
        }
    }

    protected void setSendMessageCommandCallback() {
        this.sendMessageCommand.setCallback(new SendFileCommand.SendFileCommandListener(){

            @Override
            public void onFileAddedToDB(long messageRowId, long fileRowId) {
                BaseUploadTask.this.mFileRowId = fileRowId;
                BaseUploadTask.this.mMessageRowId = messageRowId;
                if (BaseUploadTask.this.mUploadFileTaskCallback != null) {
                    BaseUploadTask.this.mUploadFileTaskCallback.onFileAddedToDB();
                }
            }

            @Override
            public void onMessageUpdatedInDB() {
                BaseUploadTask.this.generateUrl();
            }
        });
    }

    private void generateUrl() {
        this.setStatus(FilesTable.LoadStatus.REQUESTING_URL);
        LPMobileLog.d((String)(TAG + Thread.currentThread()), (String)"generateUrlRunnable");
        SocketManager.getInstance().send((BaseSocketRequest)new GetUrlForUploadRequest(MessagingFactory.getInstance().getController(), this.getUploadTaskBundle().getBrandId(), this.getFileByteArray().length, this.getUploadTaskBundle().getFileTypeExtension(), new IOnUrlReady(){

            @Override
            public void onUrlReady(BaseGenerateURLResponse body) {
                LPMobileLog.d((String)(BaseUploadTask.TAG + Thread.currentThread()), (String)("URL ready!!" + body.relativePath));
                BaseUploadTask.this.mRelativePath = body.relativePath;
                MessagingFactory.getInstance().getController().amsFiles.updateRelativePath(BaseUploadTask.this.mFileRowId, BaseUploadTask.this.mRelativePath);
                if (BaseUploadTask.this.isUploadFailed()) {
                    return;
                }
                BaseUploadTask.this.uploadToSwift(body.queryParams);
            }

            @Override
            public void onUrlError(String errorMessage) {
                if (BaseUploadTask.this.isUploadFailed()) {
                    return;
                }
                BaseUploadTask.this.onUploadFailed(new Exception("failed to generate url." + errorMessage));
            }
        }));
    }

    public void setCallBack(UploadFileTaskCallback uploadFileTaskCallback) {
        this.mUploadFileTaskCallback = uploadFileTaskCallback;
    }

    private void uploadToSwift(QueryParams queryParams) {
        LPMobileLog.d((String)(TAG + Thread.currentThread()), (String)"uploading to swift..");
        this.setStatus(FilesTable.LoadStatus.UPLOADING);
        UploadFileRequest mUploadFileRequest = new UploadFileRequest(this.getUploadTaskBundle().getSwiftDomain(), this.mRelativePath, queryParams, this.getUploadTaskBundle().getRestParams().mCertificates, new ICallback(){

            public void onSuccess(Object value) {
                if (BaseUploadTask.this.isUploadFailed()) {
                    return;
                }
                LPMobileLog.d((String)(BaseUploadTask.TAG + Thread.currentThread()), (String)"uploading to swift succeeded!");
                BaseUploadTask.this.setStatus(FilesTable.LoadStatus.COMPLETED);
                if (BaseUploadTask.this.mUploadFileTaskCallback != null) {
                    BaseUploadTask.this.mUploadFileTaskCallback.onUploadFinishedSuccessfully(BaseUploadTask.this);
                }
            }

            public void onError(Throwable exception) {
                if (BaseUploadTask.this.isUploadFailed()) {
                    return;
                }
                BaseUploadTask.this.onUploadFailed(new Exception("failed to upload to swift " + exception.getMessage()));
            }
        }, this.getFileByteArray(), this.mUploadTimeout);
        mUploadFileRequest.execute();
    }

    public void startUpload() {
        if (this.sendMessageCommand != null) {
            this.sendMessageCommand.addMessageToDB();
        }
    }

    public void onConnectionAvailable() {
        LPMobileLog.d((String)(TAG + Thread.currentThread()), (String)"onConnectionAvailable");
        if (this.mStatus == FilesTable.LoadStatus.NOT_STARTED) {
            this.setStatus(FilesTable.LoadStatus.PROCESSING);
            this.sendMessageCommand.updateMessageConversationId();
        }
    }

    public void onConnectionUnavailable() {
        this.onUploadFailed(new Exception("Failed to upload. connection unavailable"));
    }

    protected void onUploadFailed(Throwable exception) {
        LPMobileLog.d((String)TAG, (String)"onUploadFailed. ", (Throwable)exception);
        if (this.sendMessageCommand != null) {
            this.sendMessageCommand.failMessage();
        }
        this.setStatus(FilesTable.LoadStatus.FAILED);
        if (this.mUploadFileTaskCallback != null) {
            this.mUploadFileTaskCallback.onUploadFailed(this, exception);
        }
    }

    private void notifyChange() {
        MessagingFactory.getInstance().getController().amsMessages.updateFileMessageByRowId(this.mMessageRowId, this.mFileRowId).execute();
    }

    public void sendPublishFile(boolean sendViaRest) {
        LPMobileLog.d((String)(TAG + Thread.currentThread()), (String)"sending PublishImage request..");
        this.sendMessageCommand.setFileDetails(this.mRelativePath, this.getUploadTaskBundle().getFileTypeExtension(), this.getThumbnailBase64());
        this.sendMessageCommand.setSendViaRest(sendViaRest, this.getUploadTaskBundle().getRestParams());
        this.sendMessageCommand.execute();
    }

    public void setStatus(FilesTable.LoadStatus status) {
        this.mStatus = status;
        LPMobileLog.d((String)(TAG + Thread.currentThread()), (String)("set file status: " + status + " mFileRowId = " + this.mFileRowId));
        if (this.mFileRowId != -1L) {
            MessagingFactory.getInstance().getController().amsFiles.updateStatus(this.mFileRowId, this.mStatus);
        }
        this.notifyChange();
    }

    public long getMessageRowId() {
        return this.mMessageRowId;
    }

    public boolean isUploadCompleted() {
        return this.mStatus == FilesTable.LoadStatus.COMPLETED;
    }

    public boolean isUploadFailed() {
        return this.mStatus == FilesTable.LoadStatus.FAILED;
    }

    public String getEventId() {
        return this.sendMessageCommand != null ? this.sendMessageCommand.getEventId() : null;
    }
}

