/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.controller;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.SparseArray;
import com.liveperson.infra.Clearable;
import com.liveperson.infra.Infra;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.messaging.R;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientProperties
implements Clearable {
    private static final String TAG = "ClientProperties";
    private static final String APP_ID_PREFERENCE_KEY = "APP_ID_PREFERENCE_KEY";
    private static final String SDK_VERSION_PREFERENCE_KEY = "SDK_VERSION_PREFERENCE_KEY";
    private static final String APP_ID = "appId";
    private static final String DEVICE_FAMILY = "deviceFamily";
    private static final String OS = "os";
    private static final String IP_ADDRESS = "ipAddress";
    private static final String OS_NAME = "osName";
    private static final String OS_VERSION = "osVersion";
    private static final String INTEGRATION = "integration";
    private static final String INTEGRATION_VERSION = "integrationVersion";
    private static final String TIME_ZONE = "timeZone";
    private static final String DEVICE_MANUFACTURER = "deviceManufacture";
    private static final String DEVICE_MODEL = "deviceModel";
    private static final String APP_VERSION = "appVersion";
    private static final String FEATURES = "features";
    private static final String TYPE = "type";
    private static final String TYPE_VALUE = ".ClientProperties";
    private String mAppId;
    private String mSdkVersion;
    private final String ipAddress;
    private JSONObject mJson;

    public ClientProperties(String appId, String appVersion) {
        String _ipAddress = "unknown";
        try {
            _ipAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LPMobileLog.e((String)TAG, (String)"Failed to get ip address, unknown host exception.", (Throwable)e);
        }
        this.ipAddress = _ipAddress;
        this.saveAppId(appId);
        this.saveSDKVersion(appVersion);
        this.createJson();
        LPMobileLog.v((String)TAG, (String)ClientProperties.getLoggablePropertyDump(Infra.instance.getApplicationContext(), "Created ClientProperties:", appId));
    }

    public ClientProperties() {
        this(null, null);
    }

    private void createJson() {
        this.mJson = new JSONObject();
        try {
            this.mJson.put(APP_ID, (Object)this.mAppId);
            this.mJson.put(APP_VERSION, (Object)ClientProperties.getAppVersion(Infra.instance.getApplicationContext()));
            this.mJson.put(DEVICE_FAMILY, (Object)DeviceFamily.MOBILE.name());
            this.mJson.put(OS, (Object)OperatingSystem.ANDROID.name());
            this.mJson.put(OS_NAME, (Object)ClientProperties.getOsName());
            this.mJson.put(OS_VERSION, (Object)String.valueOf(Build.VERSION.SDK_INT));
            this.mJson.put(DEVICE_MODEL, (Object)Build.MODEL);
            this.mJson.put(DEVICE_MANUFACTURER, (Object)Build.MANUFACTURER);
            this.mJson.put(INTEGRATION, (Object)Integration.MOBILE_SDK.name());
            this.mJson.put(INTEGRATION_VERSION, (Object)this.mSdkVersion);
            this.mJson.put(TYPE, (Object)TYPE_VALUE);
            JSONArray featuresArray = new JSONArray();
            featuresArray.put((Object)Features.PHOTO_SHARING.name()).put((Object)Features.CO_APP.name()).put((Object)Features.RICH_CONTENT.name()).put((Object)Features.SECURE_FORMS.name()).put((Object)Features.AUTO_MESSAGES.name()).put((Object)Features.QUICK_REPLIES.name()).put((Object)Features.MULTI_DIALOG.name());
            if (Configuration.getBoolean((int)R.bool.enable_file_Sharing)) {
                featuresArray.put((Object)Features.FILE_SHARING.name());
            }
            this.mJson.put(FEATURES, (Object)featuresArray);
            this.mJson.put(TIME_ZONE, (Object)TimeZone.getDefault().getID());
        }
        catch (JSONException e) {
            LPMobileLog.e((String)TAG, (String)"JSONException while adding properties to JSON Object.", (Throwable)e);
        }
    }

    public String getJsonString() {
        return this.mJson.toString();
    }

    public void addToUriBuilder(Uri.Builder builder) {
        builder.appendQueryParameter(APP_ID, this.mAppId).appendQueryParameter(APP_VERSION, ClientProperties.getAppVersion(Infra.instance.getApplicationContext())).appendQueryParameter(DEVICE_FAMILY, DeviceFamily.MOBILE.name()).appendQueryParameter(IP_ADDRESS, this.ipAddress).appendQueryParameter(OS, OperatingSystem.ANDROID.name()).appendQueryParameter(OS_NAME, ClientProperties.getOsName()).appendQueryParameter(OS_VERSION, String.valueOf(Build.VERSION.SDK_INT)).appendQueryParameter(DEVICE_MODEL, Build.MODEL).appendQueryParameter(DEVICE_MANUFACTURER, Build.MANUFACTURER).appendQueryParameter(INTEGRATION, Integration.MOBILE_SDK.name()).appendQueryParameter(INTEGRATION_VERSION, this.mSdkVersion).appendQueryParameter(FEATURES, Features.PHOTO_SHARING.name() + "," + Features.CO_APP.name() + "," + Features.RICH_CONTENT.name() + "," + Features.SECURE_FORMS.name() + "," + Features.AUTO_MESSAGES.name() + "," + Features.QUICK_REPLIES.name() + "," + Features.MULTI_DIALOG.name()).appendQueryParameter(TIME_ZONE, TimeZone.getDefault().getID());
    }

    public void saveAppId(String newAppId) {
        if (TextUtils.isEmpty((CharSequence)newAppId)) {
            this.mAppId = PreferenceManager.getInstance().getStringValue(APP_ID_PREFERENCE_KEY, "appLevelPreferences", "");
        } else {
            this.mAppId = newAppId;
            PreferenceManager.getInstance().setStringValue(APP_ID_PREFERENCE_KEY, "appLevelPreferences", this.mAppId);
        }
    }

    public void saveSDKVersion(String newSdkVersion) {
        if (TextUtils.isEmpty((CharSequence)newSdkVersion)) {
            this.mSdkVersion = PreferenceManager.getInstance().getStringValue(SDK_VERSION_PREFERENCE_KEY, "appLevelPreferences", "");
        } else {
            String oldSdkVersion = PreferenceManager.getInstance().getStringValue(SDK_VERSION_PREFERENCE_KEY, "appLevelPreferences", "");
            if (!TextUtils.isEmpty((CharSequence)oldSdkVersion) && !oldSdkVersion.equals(newSdkVersion)) {
                PreferenceManager.getInstance().setBooleanValue("SDK_VERSION_CHANGED_CLEAR_DATABASE_KEY", "appLevelPreferences", true);
            }
            this.mSdkVersion = newSdkVersion;
            PreferenceManager.getInstance().setStringValue(SDK_VERSION_PREFERENCE_KEY, "appLevelPreferences", this.mSdkVersion);
        }
    }

    public void clear() {
        PreferenceManager.getInstance().remove(APP_ID_PREFERENCE_KEY, "appLevelPreferences");
        PreferenceManager.getInstance().remove(SDK_VERSION_PREFERENCE_KEY, "appLevelPreferences");
        PreferenceManager.getInstance().remove("SDK_VERSION_CHANGED_CLEAR_DATABASE_KEY", "appLevelPreferences");
    }

    @NonNull
    private static String getAppVersion(@NonNull Context appContext) {
        try {
            PackageInfo packageInfo = appContext.getPackageManager().getPackageInfo(appContext.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException nnfe) {
            LPMobileLog.w((String)TAG, (String)"Could not find package for our own package name!", (Throwable)nnfe);
        }
        catch (NullPointerException npe) {
            LPMobileLog.w((String)TAG, (String)"NPE while trying to fetch our app's version number!", (Throwable)npe);
        }
        return "";
    }

    @NonNull
    private static String getOsName() {
        AndroidVersion ver = AndroidVersion.fromSdkVersionCode(Build.VERSION.SDK_INT);
        if (ver != null) {
            return ver.logName;
        }
        return String.format("Unknown (%s)", Build.VERSION.RELEASE);
    }

    @NonNull
    public static String getLoggablePropertyDump(@NonNull Context applicationContext, @NonNull String dumpTitle, @Nullable String appId) {
        return "\n========================================\n" + dumpTitle + "\n----------------------------------------\nDevice Family:      " + DeviceFamily.MOBILE.name() + "\nOS:                 " + OperatingSystem.ANDROID.name() + "\nOS Name:            " + ClientProperties.getOsName() + "\nOS Version:         " + Build.VERSION.RELEASE + "\nOS Codename:        " + Build.VERSION.CODENAME + "\nAPI Version:        " + Build.VERSION.SDK_INT + "\nDevice Model:       " + Build.MODEL + "\nDevice Maker:       " + Build.MANUFACTURER + "\n" + (appId != null ? "Host App ID:        " + appId + "\n" : "") + "Host App Version:   " + ClientProperties.getAppVersion(applicationContext) + "\nLP Client:          " + Integration.MOBILE_SDK.name() + "\nLP Client Version:  " + "4.3.1" + "\n========================================";
    }

    public static enum Features {
        CO_BROWSE,
        CO_APP,
        PHOTO_SHARING,
        SECURE_FORMS,
        RICH_CONTENT,
        AUTO_MESSAGES,
        QUICK_REPLIES,
        MULTI_DIALOG,
        FILE_SHARING;

    }

    private static enum Browser {
        CHROME,
        FIREFOX,
        IE,
        OPERA,
        SAFARI,
        OTHER;

    }

    private static enum Integration {
        WEB_SDK,
        MOBILE_SDK,
        BRAND_SDK;

    }

    private static enum AndroidVersion {
        BASE(1, "Base (1.0)"),
        BASE_1_1(2, "Base (1.1)"),
        CUPCAKE(3, "Cupcake (1.5)"),
        DONUT(4, "Donut (1.6)"),
        ECLAIR(5, "Eclair (2.0)"),
        ECLAIR_0_1(6, "Eclair (2.0.1)"),
        ECLAIR_MR1(7, "Eclair (2.1)"),
        FROYO(8, "Froyo (2.2)"),
        GINGERBREAD(9, "Gingerbread (2.3)"),
        GINGERBREAD_MR1(10, "Gingerbread (2.3.3)"),
        HONEYCOMB(11, "Honeycomb (3.0)"),
        HONEYCOMB_MR1(12, "Honeycomb (3.1)"),
        HONEYCOMB_MR2(13, "Honeycomb (3.2)"),
        ICE_CREAM_SANDWICH(14, "Ice Cream Sandwich (4.0)"),
        ICE_CREAM_SANDWICH_MR1(15, "Ice Cream Sandwich (4.0.3)"),
        JELLY_BEAN(16, "Jelly Bean (4.1)"),
        JELLY_BEAN_MR1(17, "Jelly Bean (4.2)"),
        JELLY_BEAN_MR2(18, "Jelly Bean (4.3)"),
        KITKAT(19, "Kitkat (4.4)"),
        KITKAT_WATCH(20, "Kitkat Watch (4.4W)"),
        LOLLIPOP(21, "Lollipop (5.0)"),
        LOLLIPOP_MR1(22, "Lollipop (5.1)"),
        MARSHMALLOW(23, "Marshmallow (6.0)"),
        NOUGAT(24, "Nougat (7.0)"),
        NOUGAT_MR1(25, "Nougat (7.1)"),
        OREO(26, "Oreo (8.0)"),
        OREO_MR1(27, "Oreo (8.1)"),
        PIE(28, "Pie (9.0)"),
        Q(29, "Q (10.0)");

        public final int verCode;
        @NonNull
        public final String logName;
        private static final SparseArray<AndroidVersion> verCodeMap;

        private AndroidVersion(int verCode, String logName) {
            this.verCode = verCode;
            this.logName = logName;
        }

        public static AndroidVersion fromSdkVersionCode(int verCode) {
            return (AndroidVersion)((Object)verCodeMap.get(verCode));
        }

        static {
            verCodeMap = new SparseArray();
            for (AndroidVersion version : AndroidVersion.values()) {
                verCodeMap.put(version.verCode, (Object)version);
            }
        }
    }

    private static enum OperatingSystem {
        WINDOWS,
        LINUX,
        OSX,
        ANDROID,
        IOS,
        OTHER;

    }

    private static enum DeviceFamily {
        MOBILE,
        TABLET,
        PERSONAL_COMPUTER,
        PDA,
        OTHER,
        UNKNOWN;

    }
}

