/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.utils.LocaleUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class Form {
    private static final String TAG = "Form";
    private String mDialogId;
    private String mConversationId;
    private String mInvitationId;
    private String mSubmissionId;
    private String mReadOTK;
    private String mLanguage;
    private String mWriteOTK;
    private String mFormId;
    private String mEventId;
    private int mSeqId;
    private String mSiteId;
    private String mFormTitle;
    private FormStatus mFormStatus;
    private String mTokenizer;
    private boolean hideLogo;
    private String fontName;
    private static final String CSS = "{\"1\":{\"f\":\"%1$s\"}}";

    public Form(String dialogId, String conversationId, String mInvitationId, String mFormId, String mFormTitle, String tokenizer, String mSiteId, int seqId, String eventId) {
        this.mDialogId = dialogId;
        this.mConversationId = conversationId;
        this.mInvitationId = mInvitationId;
        this.mFormId = mFormId;
        this.mFormTitle = mFormTitle;
        this.mTokenizer = tokenizer;
        this.mSiteId = mSiteId;
        this.mSeqId = seqId;
        this.mFormStatus = FormStatus.READY;
        this.mEventId = eventId;
        this.mLanguage = LocaleUtils.getInstance().getLocaleCode();
        this.hideLogo = Configuration.getBoolean((int)R.bool.pci_form_hide_logo);
        this.fontName = Configuration.getString((int)R.string.pci_form_font_name);
        LPMobileLog.d((String)TAG, (String)("New form was created: " + this));
    }

    public void setSubmissionId(String submissionId) {
        this.mSubmissionId = submissionId;
    }

    public void setReadOTK(String readOTK) {
        this.mReadOTK = readOTK;
    }

    public void setWriteOTK(String writeOTK) {
        this.mWriteOTK = writeOTK;
    }

    public void setFormStatus(FormStatus formStatus) {
        LPMobileLog.d((String)TAG, (String)("maayan setFormStatus: " + (Object)((Object)formStatus) + " invId: " + this.mInvitationId));
        this.mFormStatus = formStatus;
    }

    public String getOpenFormURL() {
        String format = String.format(CSS, this.fontName);
        String encodedCss = "";
        try {
            encodedCss = URLEncoder.encode(format, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LPMobileLog.e((String)TAG, (String)"Unsupported URL encoding format.", (Throwable)e);
        }
        return "https://" + this.mTokenizer + "/pcigw/pci_dynamic_le.jsp?siteid=" + this.mSiteId + "&redirect=https://" + this.mTokenizer + "/pcigw/pci_dynamic_submitted_le.html&otk=" + this.mWriteOTK + "&lang=" + this.getLanguage() + "&formOtk=" + this.mReadOTK + "&otkJson=" + this.mSiteId + ":" + this.mInvitationId + "&hideLogo=" + this.hideLogo + "&css=" + encodedCss;
    }

    public String toString() {
        return "Form {mDialogId='" + this.mDialogId + '\'' + ", mInvitationId='" + this.mInvitationId + '\'' + ", mSubmissionId='" + this.mSubmissionId + '\'' + ", mReadOTK='" + this.mReadOTK + '\'' + ", mWriteOTK='" + this.mWriteOTK + '\'' + ", mFormId='" + this.mFormId + '\'' + ", mEventId='" + this.mEventId + '\'' + ", mSeqId=" + this.mSeqId + ", mSiteId='" + this.mSiteId + '\'' + ", mFormTitle='" + this.mFormTitle + '\'' + ", mFormStatus=" + (Object)((Object)this.mFormStatus) + ", mTokenizer='" + this.mTokenizer + '\'' + ", mLang='" + this.mLanguage + '\'' + '}';
    }

    public String getDialogId() {
        return this.mDialogId;
    }

    public String getConversationId() {
        return this.mConversationId;
    }

    public String getInvitationId() {
        return this.mInvitationId;
    }

    public String getSubmissionId() {
        return this.mSubmissionId;
    }

    public String getReadOTK() {
        return this.mReadOTK;
    }

    public String getWriteOTK() {
        return this.mWriteOTK;
    }

    public String getFormId() {
        return this.mFormId;
    }

    public String getEventId() {
        return this.mEventId;
    }

    public int getSeqId() {
        return this.mSeqId;
    }

    public String getSiteId() {
        return this.mSiteId;
    }

    public String getFormTitle() {
        return this.mFormTitle;
    }

    public String getLanguage() {
        return this.mLanguage;
    }

    public FormStatus getFormStatus() {
        return this.mFormStatus;
    }

    public static enum FormStatus {
        READY,
        VIEWED,
        SUBMITTED,
        ERROR,
        ABORTED,
        EXPIRED,
        COMPLETED;

    }
}

