/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.http;

import android.net.Uri;
import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.body.HttpRequestBody;
import com.liveperson.infra.network.http.body.HttpStringRequestBody;
import com.liveperson.infra.network.http.request.HttpPostRequest;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.infra.network.socket.SocketToRestCommand;
import com.liveperson.messaging.network.http.RestRequestParams;
import com.liveperson.messaging.network.socket.requests.SendMessageRequest;

public class SendFileRequestRest
extends SocketToRestCommand
implements Command {
    private static final String TAG = "SendFileRequestRest";
    private static final int UPLOAD_IMAGE_TIMEOUT = 30000;
    private final RestRequestParams params;
    private final BaseAMSSocketRequest sendMessageRequest;
    private ICallback mCallback;

    public SendFileRequestRest(RestRequestParams params, SendMessageRequest sendMessageRequest) {
        this.params = params;
        this.sendMessageRequest = sendMessageRequest;
    }

    public void execute() {
        Uri.Builder builder = new Uri.Builder();
        String mDomainTemplate = "https://%1$s/rest_api/account/%2$s/messaging/consumer/%3$s";
        builder.path(String.format(mDomainTemplate, this.params.mDomain, this.params.mBrandId, this.params.mToken));
        HttpPostRequest httpPostRequest = new HttpPostRequest(builder.build().toString());
        HttpStringRequestBody body = new HttpStringRequestBody(){

            public String get() {
                return SendFileRequestRest.this.getData(SendFileRequestRest.this.sendMessageRequest);
            }

            public String getContentType() {
                return "application/json";
            }
        };
        httpPostRequest.setBody((HttpRequestBody)body);
        httpPostRequest.setCertificatePinningKeys(this.params.mCertificates);
        httpPostRequest.setTimeout(30000);
        LPMobileLog.d((String)TAG, (String)"Sending upload file to swift: ");
        httpPostRequest.setCallback((ICallback)new ICallback<String, Exception>(){

            public void onSuccess(String body) {
                LPMobileLog.d((String)SendFileRequestRest.TAG, (String)("Rest response: " + body));
            }

            public void onError(Exception exception) {
            }
        });
        HttpHandler.execute((HttpRequest)httpPostRequest);
    }
}

