/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.socket.requests;

import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.request.ReqBody;
import com.liveperson.api.request.UpdateConversationField;
import com.liveperson.api.response.types.TTRType;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import org.json.JSONException;
import org.json.JSONObject;

public class ChangeConversationTTRRequest
extends BaseAMSSocketRequest<ReqBody.StringResp, ChangeConversationTTRRequest> {
    private static final String TAG = ChangeConversationTTRRequest.class.getSimpleName();
    private String mConversationId;
    private TTRType mTTRType;
    private int mValue;

    public ChangeConversationTTRRequest(String socketUrl, String convServerId, TTRType type, int value) {
        super(socketUrl);
        this.mConversationId = convServerId;
        this.mTTRType = type;
        this.mValue = value;
    }

    protected String getData() {
        return new UpdateConversationField(this.mConversationId, "TTRField", this.mTTRType, this.mValue).toJsonString(this.getRequestId());
    }

    protected String getRequestName() {
        return TAG;
    }

    protected BaseResponseHandler getResponseHandler() {
        return new BaseResponseHandler<ReqBody.StringResp, ChangeConversationTTRRequest>(){

            public String getAPIResponseType() {
                return "StringResponse";
            }

            protected ReqBody.StringResp parse(JSONObject jsonObject) throws JSONException {
                return new ReqBody.StringResp(jsonObject);
            }

            protected boolean handle(ReqBody.StringResp data) {
                LPMobileLog.d((String)TAG, (String)("Got change ttr response: " + data.getBody()));
                return true;
            }
        };
    }
}

