package com.liveperson.messaging;

import com.liveperson.api.response.events.ExConversationChangeNotification;
import com.liveperson.api.response.events.MessagingEventNotification;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.infra.network.socket.GeneralResponseHandler;
import com.liveperson.infra.network.socket.ResponseMap;

/**
 * Created by shiranr on 8/15/16.
 */
public class GeneralMessagingResponseHandler extends GeneralResponseHandler {

    private static final String TAG = "GeneralMessagingResponseHandler";
    private final Messaging mController;

    GeneralMessagingResponseHandler(Messaging controller){
        mController = controller;
    }

    protected BaseResponseHandler createInstance(String responseType) {
        if (responseType.equals(ExConversationChangeNotification.getType())) {
            LPMobileLog.d(ResponseMap.RESPONSE_TAG + TAG, "Creating general response - ExConversationChangeNotification - for message type :" + responseType);
            return ExConversationChangeNotification.getResponseHandler(mController);
        }

        if (responseType.equals(MessagingEventNotification.Companion.getType())) {
            LPMobileLog.d(ResponseMap.RESPONSE_TAG + TAG, "Creating general response - MessagingEventNotification - for message type :" + responseType);
            return MessagingEventNotification.Companion.getResponseHandler(mController);
        }

        LPMobileLog.e(ResponseMap.RESPONSE_TAG + TAG, "Couldn't find general response for message type :" + responseType);
        return null;
    }
}
