package com.liveperson.messaging.commands;

import com.liveperson.infra.Command;
import com.liveperson.infra.model.types.ChatState;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.model.AmsDialogs;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.network.socket.requests.ChatStateChangeRequest;


/**
 * Created by shiranr on 17/11/2015.
 */
public class ChangeChatStateCommand implements Command {
    //private final AmsConversations mConversations;
    private final AmsDialogs mDialogs;
    private ChatState mState;
    private String mTargetId;
    private String mSocketUrl;

    public ChangeChatStateCommand(AmsDialogs amsDialogs, String targetId, String socketUrl, ChatState state) {
        mDialogs = amsDialogs;
        mTargetId = targetId;
        mSocketUrl = socketUrl;
        mState = state;
    }

    @Override
    public void execute() {
        final Dialog dialog = mDialogs.getActiveDialog();
        if (dialog != null) {
            switch (dialog.getState()) {
                case OPEN:
                    SocketManager.getInstance().send(new ChatStateChangeRequest(mSocketUrl, dialog.getDialogId(), dialog.getConversationId(), mState));
                    break;
                default:
                    //Do nothing
                    break;
            }
        }
    }
}