package com.liveperson.messaging.commands;

import com.liveperson.api.response.types.TTRType;
import com.liveperson.infra.Command;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.model.AmsConversations;
import com.liveperson.messaging.network.socket.requests.ChangeConversationTTRRequest;


/**
 * Created by shiranr on 18/11/2015.
 */
public class ChangeConversationTTRCommand implements Command {
    private static final String TAG = ChangeConversationTTRCommand.class.getSimpleName();
    private final AmsConversations mAmsConversations;
    private TTRType mTTRType;
    private String mSocketUrl;
    private String mTargetId;

    public ChangeConversationTTRCommand(AmsConversations amsConversations, String targetId, String socketUrl, TTRType ttrType) {
        mAmsConversations = amsConversations;
        mTargetId = targetId;
        mSocketUrl = socketUrl;
        mTTRType = ttrType;
    }

    @Override
    public void execute() {
        if (!mAmsConversations.isConversationActive(mTargetId)) {
            LPMobileLog.w(TAG, "No open conversation found. aborting changing ttr type command");
            return;
        }
        String conversationServerId = mAmsConversations.getConversation(mTargetId).getConversationId();
        ChangeConversationTTRRequest baseSocketRequest = new ChangeConversationTTRRequest(mSocketUrl, conversationServerId, mTTRType, 0);
        SocketManager.getInstance().send(baseSocketRequest);
    }
}