package com.liveperson.messaging.commands;

import android.text.TextUtils;

import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.messaging.Messaging;

import org.json.JSONObject;

public class GetCombinedUnreadMessagesCountCommand implements Command {

    public static final String TAG = "GetCombinedUnreadMessagesCountCommand";

    private Messaging mController;
    private String mBrandId;
    private ICallback<Integer, Exception> mCallback;
    private String mAppId;
    private static boolean isRegisteredToPusher = true;
    public GetCombinedUnreadMessagesCountCommand(Messaging messagingController, String brandId, String appId, ICallback<Integer, Exception> callback) {
        mController = messagingController;
        mBrandId = brandId;
        mAppId = appId;
        mCallback = callback;
    }


    @Override
    public void execute() {
        if (isRegisteredToPusher) {
            LPMobileLog.d(TAG, "Getting unread count!!!!! from pusher");
            getUnreadMessageCountFromPusher();
        } else {
            LPMobileLog.d(TAG, "Getting unread count!!!!! from ums");
            getUnreadMessageCountFromUMS();
        }
    }

    /**
     * Try to get Unread messages count from pusher. This will return an error If user is not registered for pusher.
     */
    private void getUnreadMessageCountFromPusher() {
        new GetUnreadMessagesCountCommand(mController, mBrandId, mAppId, new ICallback<Integer, Exception>() {

            @Override
            public void onSuccess(Integer value) {
                mCallback.onSuccess(value);
            }

            @Override
            public void onError(Exception exception) {
                LPMobileLog.d(TAG, "Pusher returned error: " + exception);
                if (exception != null) {
                    try {
                        String mess = parseException(exception.getMessage());
                        JSONObject error = new JSONObject(mess);
                        String errorString =  error.getString("error");
                        if (!TextUtils.isEmpty(errorString)) {
                            JSONObject errorBody = new JSONObject(errorString);
                            String statusCode = errorBody.getString("statusCode");
                            String internalCode = errorBody.getString("internalCode");

                            if (statusCode.equals("404") && internalCode.equals("16")) {
                                setIsRegisteredToPusher(false);
                            }
                        }

                    } catch (Exception e) {
                        LPMobileLog.e(TAG, "Failed to parse unread message count exception from pusher.", e);
                    }
                    getUnreadMessageCountFromUMS();
                }
            }
        }).execute();
    }

    /**
     * Get Unread messages count from UMS.
     */
    private void getUnreadMessageCountFromUMS() {
        new GetUnreadMessagesCountFromUMSCommand(mController, mBrandId, new ICallback<Integer, Exception>() {
            @Override
            public void onSuccess(Integer value) {
                mCallback.onSuccess(value);
            }

            @Override
            public void onError(Exception exception) {
                mCallback.onError(exception);
            }
        }).execute();
    }

    /**
     * Extract actual error object from Exception.
     * @param exception
     * @return
     */
    private String parseException(String exception) {
        return exception.substring(exception.indexOf('{'));
    }

    public static void setIsRegisteredToPusher(boolean value) {
        isRegisteredToPusher = value;
    }
}
