package com.liveperson.messaging.commands;

import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.MessagingChatMessage;

public class ReSendDocumentCommand extends SendDocumentCommand {

    private long mFileRowId;
    private long mOriginalMessageTime;
    /**
     * Creates a command for sending messages
     *
     * @param controller
     * @param targetId
     * @param brandId
     * @param contentType
     * @param thumbnailPath
     * @param filePath
     * @param fileTypeExtension
     * @param message
     * @param previewContentType
     */
    public ReSendDocumentCommand(Messaging controller, String targetId, String brandId, String contentType, String thumbnailPath, String filePath, String fileTypeExtension, MaskedMessage message, String previewContentType, String eventId, long originalMessageTime, long fileRowId) {
        super(controller, targetId, brandId, contentType, thumbnailPath, filePath, fileTypeExtension, message, previewContentType);

        mOriginalMessageTime = originalMessageTime;
        mFileRowId = fileRowId;
        mEventId = eventId;
    }

    @Override
    protected void addMessageToDBAndSend(String conversationId, MaskedMessage message) {
        mController.amsMessages.updateMessageState(mEventId, mTargetId, conversationId, MessagingChatMessage.MessageState.QUEUED);
        mController.amsMessages.getRowIdByEventId(mEventId).setPostQueryOnBackground(new DataBaseCommand.QueryCallback<Long>() {
            @Override
            public void onResult(Long data) {
                mMessageRowId = data;
                if (mCallback != null) {
                    mCallback.onFileAddedToDB(mMessageRowId, mFileRowId);
                }
            }
        }).execute();
    }

    @Override
    protected long getMessageTime() {
        return mOriginalMessageTime;
    }
}
