package com.liveperson.messaging.commands;

import android.support.annotation.NonNull;

import com.liveperson.infra.utils.DateUtils;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.MessagingChatMessage;

public class SendVoiceCommand extends SendFileCommand {

	private String mPreviewContentType;
	/**
	 * Creates a command for sending messages
	 *
	 * @param controller
	 * @param targetId
	 * @param brandId
	 * @param contentType
	 * @param thumbnailPath
	 * @param filePath
	 * @param fileTypeExtension
	 * @param message
	 */
	public SendVoiceCommand(Messaging controller, String targetId, String brandId, String contentType, String thumbnailPath, String filePath, String fileTypeExtension, MaskedMessage message, String previewContentType) {
		super(controller, targetId, brandId, contentType, thumbnailPath, filePath, fileTypeExtension, message);

		mPreviewContentType = previewContentType;
	}

	@NonNull
	protected MessagingChatMessage.MessageType getMessageType(MaskedMessage message) {
		return MessagingChatMessage.MessageType.CONSUMER_VOICE;
	}

	public void setFileDetails(String relativePath, String fileType, String previewBase64){

		super.setFileDetails(relativePath, fileType, previewBase64);

		this.mPreview = "data:" + mPreviewContentType + ";base64,"+ previewBase64;

	}

	/**
	 * Set the given milliseconds as the message caption (converted to String)
	 * @param milliseconds
	 */
	public void setDurationAsCaption(long milliseconds) {

		String durationString = String.valueOf(milliseconds);
		mMessage.setServerMessage(durationString);
		mMessage.setDbMessage(durationString);
		mCaption = durationString;
	}
}
