package com.liveperson.messaging.commands.tasks;

import com.liveperson.api.request.ReqBody;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.ResponseCallback;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.SocketTaskType;
import com.liveperson.messaging.network.socket.requests.UnSubscribeExConversationsRequest;

/**
 * Created by nirni on 2/23/16.
 */
public class UnsubscribeExConversationTask extends BaseAmsSocketConnectionTask {

	public static final String TAG = UnsubscribeExConversationTask.class.getSimpleName();

	protected final Messaging mController;

	public UnsubscribeExConversationTask(Messaging controller) {
		mController = controller;
	}

	@Override
	public void execute() {

		// Get subscriptionId
		String subscriptionId = mController.mConnectionController.getSubscriptionId(mBrandId);

		if (subscriptionId == null) {
			LPMobileLog.d(TAG, "Cannot find subscriptionId for brand " + mBrandId);
			mCallback.onTaskSuccess();
			return;
		}

		LPMobileLog.i(TAG, "Running UnsubscribeExConversation task...");
		UnSubscribeExConversationsRequest unSubscribeExConversationsRequest = new UnSubscribeExConversationsRequest( mController.mAccountsController.getConnectionUrl(mBrandId), subscriptionId);
		unSubscribeExConversationsRequest.addCallback(new ResponseCallback<ReqBody.StringResp>() {
			@Override
			public void onSuccess(ReqBody.StringResp data) {
				mCallback.onTaskSuccess();
			}

			@Override
			public void onError() {
				mCallback.onTaskError(SocketTaskType.UN_SUBSCRIBE, new Exception(TAG));
			}
		});
		SocketManager.getInstance().send(unSubscribeExConversationsRequest);
	}
}
