package com.liveperson.messaging.model;

import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.utils.LocaleUtils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

/**
 * Created by maayank on 15/03/2017.
 * a model object that represent a Form, built for the PCI feature
 */

public class Form {

	private static final String TAG = "Form";

	private String mDialogId;
	private String mConversationId;
	private String mInvitationId;
	private String mSubmissionId;
	private String mReadOTK;
	private String mLanguage;
	private String mWriteOTK;
	private String mFormId;
	private String mEventId;
	private int mSeqId;
	private String mSiteId; // = brand id
	private String mFormTitle;
	private FormStatus mFormStatus;
	private String mTokenizer;
	private boolean hideLogo;
	private String fontName;

	//TODO maayan check this out
	//private static final String CSS = "{\"1\" : {\"bc\" : \"#FFFFFF\",\"f\" : \"Arial,Helvetica,sans-serif\",\"c\" : \"#6D6E70\"},\"2\" : {\"bc\" : \"#0363ad\",\"c\" : \"#FFFFFF\"}}";
	//private static final String CSS= "{\"body\":{\"font-family\":\"%1$s\"}}";
	private static final String CSS= "{\"1\":{\"f\":\"%1$s\"}}";


	public Form(String dialogId, String conversationId, String mInvitationId, String mFormId, String mFormTitle, String tokenizer, String mSiteId, int seqId, String eventId) {
		this.mDialogId = dialogId;
		this.mConversationId = conversationId;
		this.mInvitationId = mInvitationId;
		this.mFormId = mFormId;
		this.mFormTitle = mFormTitle;
		this.mTokenizer = tokenizer;
		this.mSiteId = mSiteId;
		this.mSeqId = seqId;
		this.mFormStatus = FormStatus.READY;
		this.mEventId = eventId;
		this.mLanguage = LocaleUtils.getInstance().getLocaleCode();
		this.hideLogo = Configuration.getBoolean(R.bool.pci_form_hide_logo);
		this.fontName = Configuration.getString(R.string.pci_form_font_name);
		LPMobileLog.d(TAG, "New form was created: " + this);
	}

//	public Form(String mConversationId, String mInvitationId, String mSubmissionId, String mReadOTK,
//				String mWriteOTK, String mFormId, String mFormTitle, String tokenizer, String eventId) {
//		this.mDialogId = mConversationId;
//		this.mInvitationId = mInvitationId;
//		this.mSubmissionId = mSubmissionId;
//		this.mReadOTK = mReadOTK;
//		this.mWriteOTK = mWriteOTK;
//		this.mFormId = mFormId;
//		this.mFormTitle = mFormTitle;
//		this.mTokenizer = tokenizer;
//		this.mFormStatus = FormStatus.READY;
//		this.mEventId = eventId;
//		this.mLanguage = LocaleUtils.getInstance().getLocaleCode();
//	}

	/**
	 Ready - The cell will have a button that says “Fill Now” and clicking it will start the process of getting the OTKs and generating the URL.
	 Viewed - The cell will have no button.
	 Error - The cell will have no button. It will say something like “There is an error showing\loading\submitting the url, please ask the agent for another form”
	 Expired -The cell will have a button that says “Request Again” and clicking it will send a message saying something like: “Please send me a new form”
	 Completed - The cell will have no button. This means that the user has filled the form.
	 */
	public enum FormStatus {
		READY, VIEWED, SUBMITTED, ERROR, ABORTED, EXPIRED, COMPLETED
	}

	public void setSubmissionId(String submissionId) {
		this.mSubmissionId = submissionId;
	}

	public void setReadOTK(String readOTK) {
		this.mReadOTK = readOTK;
	}

	public void setWriteOTK(String writeOTK) {
		this.mWriteOTK = writeOTK;
	}

	public void setFormStatus(FormStatus formStatus) {
		LPMobileLog.d(TAG, "maayan setFormStatus: "+formStatus +" invId: "+mInvitationId);
		this.mFormStatus = formStatus;
	}

	public String getOpenFormURL() {
		/*StringBuilder sb  = new StringBuilder("https://").append(mTokenizer)
				.append("/pcigw/pci_dynamic_le.jsp?siteid=").append(mSiteId)
				.append("&redirect=https://").append(mTokenizer)
				.append("/pcigw/pci_dynamic_submitted_le.html&otk=").append(mWriteOTK)
				.append("&lang=").append(mLanguage)
				.append("&formOtk=").append(mReadOTK)
				.append("&otkJson=").append(mSiteId)
				.append(":").append(mInvitationId);

		return sb.toString();*/

		//final
		//https://%@/pcigw/pci_dynamic_le.jsp?siteid=%@&redirect=https://%@/pcigw/pci_dynamic_submitted_le.html&otk=%@&formOtk=%@&otkJson=%@:%@
		String format = String.format(CSS, fontName);
		String encodedCss = "";
		try {
			encodedCss = URLEncoder.encode(format, "UTF-8");
		} catch (UnsupportedEncodingException e) {
			LPMobileLog.e(TAG, "Unsupported URL encoding format.", e);
		}

		return  "https://"+ mTokenizer +
				"/pcigw/pci_dynamic_le.jsp?siteid=" + mSiteId +
				"&redirect=https://" + mTokenizer +
				"/pcigw/pci_dynamic_submitted_le.html&otk=" + mWriteOTK +
				"&lang=" + getLanguage() +
				"&formOtk=" + mReadOTK +
				"&otkJson=" + mSiteId + ":" + mInvitationId +
				"&hideLogo="+ hideLogo +
				"&css="+ encodedCss
				;

	}

	@Override
	public String toString() {
		return "Form {" +
				"mDialogId='" + mDialogId + '\'' +
				", mInvitationId='" + mInvitationId + '\'' +
				", mSubmissionId='" + mSubmissionId + '\'' +
				", mReadOTK='" + mReadOTK + '\'' +
				", mWriteOTK='" + mWriteOTK + '\'' +
				", mFormId='" + mFormId + '\'' +
				", mEventId='" + mEventId + '\'' +
				", mSeqId=" + mSeqId +
				", mSiteId='" + mSiteId + '\'' +
				", mFormTitle='" + mFormTitle + '\'' +
				", mFormStatus=" + mFormStatus +
				", mTokenizer='" + mTokenizer + '\'' +
				", mLang='" + mLanguage + '\'' +
				'}';
	}

	public String getDialogId() {
		return mDialogId;
	}

    public String getConversationId() {
        return mConversationId;
    }

    public String getInvitationId() {
		return mInvitationId;
	}

	public String getSubmissionId() {
		return mSubmissionId;
	}

	public String getReadOTK() {
		return mReadOTK;
	}

	public String getWriteOTK() {
		return mWriteOTK;
	}

	public String getFormId() {
		return mFormId;
	}

	public String getEventId() {
		return mEventId;
	}

	public int getSeqId() {
		return mSeqId;
	}

	public String getSiteId() {
		return mSiteId;
	}

	public String getFormTitle() {
		return mFormTitle;
	}

	public String getLanguage() {
		return mLanguage;
	}

	public FormStatus getFormStatus() {
		return mFormStatus;
	}
}
