package com.liveperson.messaging.model;

import com.liveperson.infra.log.LPMobileLog;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by maayank on 15/03/2017.
 */

public class FormsManager {

	private static final String TAG = FormsManager.class.getSimpleName();
	public static final String FORM_ID = "formId";
	public static final String INVITATION_ID = "invitationId";
	public static final String TITLE = "title";

	private Map<String, Form> mFormsMap;


	public FormsManager(){
		mFormsMap = new HashMap<>();
	}

	public void addForm(String id, Form form){
		LPMobileLog.d(TAG , "form add with id: " + id+" map size: " +mFormsMap.size());

		if (mFormsMap != null){
			mFormsMap.put(id, form);
		}
	}

	public void removeForm(String id){
		if (mFormsMap != null){
			mFormsMap.remove(id);
		}
	}

	public void updateForm(String id, String readOTK, String writeOTK ){
		if (mFormsMap != null && mFormsMap.containsKey(id)){
			Form form = mFormsMap.get(id);
			form.setReadOTK(readOTK);
			form.setWriteOTK(writeOTK);
		} else {
			LPMobileLog.d(TAG , "form with id: " + id+" could not be found in map ");
		}
		LPMobileLog.d(TAG , "form update1 with id: " + id+" map size: " +mFormsMap.size());

	}

	public void updateForm(String id, String submissionId ){
		if (mFormsMap != null && mFormsMap.containsKey(id)){
			Form form = mFormsMap.get(id);
			form.setSubmissionId(submissionId);
			form.setFormStatus(Form.FormStatus.SUBMITTED);
		} else {
			LPMobileLog.d(TAG , "form with id: " + id+" could not be found in map ");
		}
		LPMobileLog.d(TAG , "form update2 with id: " + id+" map size: " +mFormsMap.size());

	}

	public Form getForm(String id){
		LPMobileLog.d(TAG , "form get with id: " + id+" map size: " +mFormsMap.size());

		return (mFormsMap != null && mFormsMap.containsKey(id)) ? mFormsMap.get(id) : null;
	}
}
