package com.liveperson.messaging.model;

import android.database.Cursor;

import com.liveperson.infra.database.tables.DialogsTable;
import com.liveperson.infra.database.tables.MessagesTable;
import com.liveperson.infra.database.tables.UsersTable;

/**
 * A container for search message result
 * Created by nirni on 1/7/16.
 */
public class MessagingSearchedMessage {

	private String mMessage;
	private String mBrandId;
	private String mFirstName;
	private MessagingChatMessage.MessageType mMessageType;

	public MessagingSearchedMessage() {
	}

	public MessagingSearchedMessage(String message, String brandId, String firstName, MessagingChatMessage.MessageType messageType) {
		mMessage = message;
		mBrandId = brandId;
		mFirstName = firstName;
		mMessageType = messageType;
	}

	public static MessagingSearchedMessage fromCursor(Cursor cursor) {
		MessagingSearchedMessage searchedMessage;

		if (cursor == null) {
			return null;
		}
		
		searchedMessage = new MessagingSearchedMessage();

		searchedMessage.setBrandId(cursor.getString(cursor.getColumnIndex(DialogsTable.Key.BRAND_ID)));
		searchedMessage.setMessage(cursor.getString(cursor.getColumnIndex(MessagesTable.KEY_TEXT))); // TODO: 2/8/16 fix (text might be encrypted)
		searchedMessage.setFirstName(cursor.getString(cursor.getColumnIndex(UsersTable.KEY_FIRST_NAME)));
		int messageType = cursor.getInt(cursor.getColumnIndex(MessagesTable.KEY_MESSAGE_TYPE));
		searchedMessage.setMessageType(MessagingChatMessage.MessageType.values()[messageType]);
		return searchedMessage;
	}

	///////////////////// Getters + setters //////////////////////////////////

	public String getMessage() {
		return mMessage;
	}

	public void setMessage(String message) {
		mMessage = message;
	}

	public String getBrandId() {
		return mBrandId;
	}

	public void setBrandId(String brandId) {
		mBrandId = brandId;
	}

	public String getFirstName() {
		return mFirstName;
	}

	public void setFirstName(String firstName) {
		mFirstName = firstName;
	}

	public MessagingChatMessage.MessageType getMessageType() {
		return mMessageType;
	}

	public void setMessageType(MessagingChatMessage.MessageType messageType) {
		mMessageType = messageType;
	}
}
