package com.liveperson.messaging.model;

import android.text.TextUtils;

import com.liveperson.api.response.model.UserProfile;
import com.liveperson.infra.utils.EncryptionVersion;

/**
 * Created by shiranr on 17/12/2015.
 */
public class MessagingUserProfile extends UserProfile {

    private static final String TAG = "MessagingUserProfile";
    private String mBrandID;
    private EncryptionVersion mEncryptionVersion;

    public MessagingUserProfile(String firstName, String lastName, UserType type) {
        super(firstName, lastName, type);
    }

    public MessagingUserProfile(UserProfile body) {
        super(body.getFirstName(), body.getLastName(), body.getUserType());
        setLocalId(body.getLocalId());
        setOriginatorID(body.getOriginatorId());
        setAvatarUrl(body.getAvatarUrl());
        setRole(body.getRole());
        setBackgndImgUri(body.getBackgndImgUri());
        setDescription(body.getDescription());
        setRequestId(body.getRequestId());
        setPrivateData(body.getPrivateData());
    }

    public String getBrandId() {
        return mBrandID;
    }

    public void setBrandID(String brandID) {
        mBrandID = brandID;
    }

    public void setUserEncryptionVersion(EncryptionVersion encryptionVersion) {
        mEncryptionVersion = encryptionVersion;
    }

    public EncryptionVersion getUserEncryptionVersion() {
        return mEncryptionVersion;
    }

    public boolean isEmptyUser() {
        return TextUtils.isEmpty(getFirstName()) && TextUtils.isEmpty(getLastName()) && TextUtils.isEmpty(getNickname());
    }
}
