package com.liveperson.messaging.network.socket.requests;

/**
 * Created by eyalv on 11/11/15.
 */

import com.liveperson.api.request.ReqBody;
import com.liveperson.api.request.UpdateConversationField;
import com.liveperson.api.response.types.CsatStatus;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.api.request.BaseAMSSocketRequest;

import org.json.JSONException;
import org.json.JSONObject;


/**
 * Created by Eyal Vites on 11/11/2015.
 */
public class CsatRequest extends BaseAMSSocketRequest<ReqBody.StringResp, CsatRequest> {

    private static final String TAG = CsatRequest.class.getSimpleName();

    private String conversationId;
    private int numOfStars;
    private int isHelpful;

    CsatStatus csatStatus;


    public CsatRequest(String socketUrl, String convServerId, int numOfStars, int isHelpful) {
        super(socketUrl);
        conversationId = convServerId;
        this.numOfStars = numOfStars;
        this.isHelpful = isHelpful;

        if (numOfStars > 0 && isHelpful > 0) {
            csatStatus = CsatStatus.FILLED;
        }else if (numOfStars == -1 && isHelpful == -1){
            csatStatus = CsatStatus.SKIPPED;
        }else{
            csatStatus = CsatStatus.PARTIALLY_FILLED;
        }
    }

    @Override
    protected String getData() {
        return new UpdateConversationField(conversationId, UpdateConversationField.CONVERSATION_CSAT_RATE, numOfStars, isHelpful, csatStatus).toJsonString(getRequestId());
    }

    @Override
    protected String getRequestName() {
        return TAG;
    }

    @Override
    protected BaseResponseHandler getResponseHandler() {
        return new BaseResponseHandler<ReqBody.StringResp, CsatRequest>() {

            @Override
            public String getAPIResponseType() {
                return ReqBody.StringResp.REQ_BODY_RESPONSE_TYPE;
            }

            @Override
            protected ReqBody.StringResp parse(JSONObject jsonObject) throws JSONException {
                return new ReqBody.StringResp(jsonObject);
            }

            @Override
            protected boolean handle(ReqBody.StringResp data) {
                //send update only when notification will arrive.
                LPMobileLog.d(TAG, "Got resolve response: " + data.getBody());
                return true;
            }
        };
    }
}



