package com.liveperson.messaging.network.socket.requests;

import com.liveperson.api.request.GenerateURLForDownloadFile;
import com.liveperson.api.response.IOnUrlReady;
import com.liveperson.messaging.Messaging;

/**
 * A request to generate url for download file request
 */
public class GetUrlForDownloadRequest extends BaseGetUrlRequest {

    private static final String TAG = GetUrlForDownloadRequest.class.getSimpleName();
    private String mRelativePath;

    /**
     * This constructor creates a SendMessageRequest with the next requestID (auto incremented)
     *
     * @param brandId
     * @param relativePath
     */
    public GetUrlForDownloadRequest(Messaging controller, String brandId, String relativePath, IOnUrlReady listener) {
        super(controller, brandId, listener);

        mRelativePath = relativePath;
    }

    @Override
    protected String getData() {
        return new GenerateURLForDownloadFile(mRelativePath).toJsonString(getRequestId());
    }

    @Override
    protected String getRequestName() {
        return TAG;
    }
}