package com.liveperson.messaging.network.socket.requests;

import android.text.TextUtils;

import com.liveperson.api.response.types.ConversationState;
import com.liveperson.api.request.GetUserProfile;
import com.liveperson.api.response.model.UserProfile;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.model.MessagingUserProfile;
import com.liveperson.api.request.BaseAMSSocketRequest;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Ilya Gazman on 11/10/2015.
 * <p/>
 * Request for creating or getting user profile
 */
public class GetUserProfileRequest extends BaseAMSSocketRequest<GetUserProfile.Response, GetUserProfileRequest> {

    private static final String TAG = GetUserProfile.class.getSimpleName();
    private final String mBrandId;
    private final Messaging mController;
    private String mUserId = "";
    private UserProfile.UserType mType;
    private String serverConversationId = "";
    private boolean mShouldUpdateUI = true;

    public GetUserProfileRequest(Messaging controller, String brandId, String targetId, UserProfile.UserType type) {
        super(controller.mAccountsController.getConnectionUrl(brandId));
        mController = controller;
        mBrandId = brandId;
        mType = type;
        String mTargetId = targetId;
    }

    /**
     * If not set new user will be returned
     *
     * @param userId
     * @return
     */
    public GetUserProfileRequest setUserId(String userId) {
        this.mUserId = userId;
        return this;
    }

    /**
     * @param dialogId - set the related dialog id
     * @return
     */
    public GetUserProfileRequest setDialogId(String dialogId) {
        this.serverConversationId = dialogId;
        //todo Perry: "??? this method never been called" (copied for later use...)
        return this;
    }

    /**
     * @param serverConversationId - set the related conversation id
     * @return
     */
    public GetUserProfileRequest setServerConversationId(String serverConversationId) {
        this.serverConversationId = serverConversationId;
        //todo Perry: "??? this method never been called"
        return this;
    }

    public GetUserProfileRequest setShouldUpdateUI(boolean shouldUpdateUI) {
        this.mShouldUpdateUI = shouldUpdateUI;
        return this;
    }

    @Override
    protected String getData() {
        return new GetUserProfile(mUserId).toJsonString(getRequestId());
    }


    @Override
    protected String getRequestName() {
        return TAG;
    }


    @Override
    protected BaseResponseHandler<GetUserProfile.Response, GetUserProfileRequest> getResponseHandler() {
        return new BaseResponseHandler<GetUserProfile.Response, GetUserProfileRequest>() {

            @Override
            public String getAPIResponseType() {
                return GetUserProfile.Response.GET_USER_PROFILE_RESPONSE_TYPE;
            }

            @Override
            protected GetUserProfile.Response parse(JSONObject jsonObject) throws JSONException {
                return new GetUserProfile.Response(jsonObject);
            }

            @Override
            protected boolean handle(GetUserProfile.Response data) {
                data.getBody().setUserType(mType);
                //will send intent to update ui
                final MessagingUserProfile userProfile = new MessagingUserProfile(data.getBody());
                userProfile.setBrandID(mBrandId);
                mController.amsUsers.updateUserProfile(userProfile);

                if (mType == UserProfile.UserType.AGENT) {
                    mController.amsDialogs.queryDialogById(serverConversationId)
                            .setPostQueryOnBackground(new DataBaseCommand.QueryCallback<Dialog>() {
                                @Override
                                public void onResult(Dialog data) {
									if (TextUtils.equals(data.getAssignedAgentId(), mUserId) && data.getState() == DialogState.OPEN) {
										LPMobileLog.d(TAG, "onResult: Calling agent details callback");
                                        mController.onAgentDetailsChanged(userProfile, data.isOpen());
									}
									//update all massages that filtered by brand id.
									//if we have open conversation with the assigned agent that we just got his profile -
									//update also messages that filtered by conversationID.
									LPMobileLog.d(TAG, "got user details (" + mUserId + ") related to conversation: " + serverConversationId);
									if (mShouldUpdateUI) {
                                        mController.amsMessages.updateAgentDetailsUpdated(mBrandId, serverConversationId);
									}
								}
							}).execute();
                }
                return true;
            }
        };
    }
}