package com.liveperson.messaging.structuredcontent.model.actions;

import android.content.Context;
import android.view.View;

import com.liveperson.messaging.structuredcontent.model.elements.BaseElement;
import com.liveperson.messaging.structuredcontent.parsers.ElementType;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by nirni on 2/2/17.
 * Abstract base class for action.
 */
public abstract class BaseAction extends BaseElement {

	/**
	 * Action name
	 */
	protected String mName;


	public BaseAction(JSONObject jsonObject) throws JSONException {
		super(jsonObject);
		mName = jsonObject.optString(ElementType.NAME); // Not mandatory
	}

	public BaseAction(String type, String name) {
		super(type);
		mName = name;
	}

	public abstract OnActionClickListener getOnClickListener(Context context, String brandId);

	public String getName() {
		return mName;
	}

}
