/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import android.content.Context;
import android.content.Intent;
import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.SocketTaskType;
import com.liveperson.messaging.commands.BasicQueryMessagesCommand;
import com.liveperson.messaging.commands.tasks.BaseAmsSocketConnectionCallback;
import com.liveperson.messaging.commands.tasks.MessagingEventSubscriptionManager;
import com.liveperson.messaging.network.socket.requests.QueryMessagesRequest;

public class QueryMessagesUMSCommand
extends BasicQueryMessagesCommand {
    private static final String TAG = QueryMessagesUMSCommand.class.getSimpleName();
    private static final int INFINITY = -2;
    private static final int CHUNK = 1000;
    private int lastCurrentSequence;
    private int unreadMessages;
    private int lastServerSequence;
    private LocalBroadcastReceiver mLocalBroadcastReceiver;

    public QueryMessagesUMSCommand(Messaging controller, String brandId, String targetId, String conversationId, String dialogId, int lastCurrentSequence, boolean updateUI) {
        super(controller, brandId, targetId, conversationId, dialogId, updateUI);
        this.lastCurrentSequence = lastCurrentSequence;
    }

    public void execute() {
        LPMobileLog.d((String)TAG, (String)("Sending query messages from sequence " + this.lastCurrentSequence));
        this.controller.getMessagingEventSubscriptionManager().addSubscription(this.controller, this.brandID, this.conversationId, this.dialogId, this.lastCurrentSequence, this.mUpdateUI);
    }

    private void queryMessages() {
        int from = this.lastCurrentSequence;
        while (this.unreadMessages > 0) {
            int to = from + 1000;
            if (to > this.lastServerSequence) {
                to = -2;
            }
            LPMobileLog.d((String)TAG, (String)("Sending query messages from sequence " + from + " to " + (to == -2 ? "infinity" : Integer.valueOf(to))));
            QueryMessagesRequest baseSocketRequest = new QueryMessagesRequest(this.controller, this.brandID, this.targetId, this.dialogId, from);
            if (to == -2) {
                to = this.lastServerSequence;
            } else {
                baseSocketRequest.setOlderThanSequenceId(to);
                baseSocketRequest.setMaxSize(to - from);
            }
            baseSocketRequest.setShouldUpdateUI(this.mUpdateUI);
            baseSocketRequest.setResponseCallBack(this.mResponseCallBack);
            SocketManager.getInstance().send((BaseSocketRequest)baseSocketRequest);
            from = to;
            this.unreadMessages = this.lastServerSequence - to;
        }
    }

    @Override
    public void setResponseCallBack(BaseAmsSocketConnectionCallback callBack) {
        super.setResponseCallBack(callBack);
        if (this.mLocalBroadcastReceiver == null) {
            this.mLocalBroadcastReceiver = new LocalBroadcastReceiver.Builder().addAction(MessagingEventSubscriptionManager.Companion.getMESSAGE_EVENT_COMPLETED() + this.dialogId).build(new LocalBroadcastReceiver.IOnReceive(){

                public void onBroadcastReceived(Context context, Intent intent) {
                    QueryMessagesUMSCommand.this.mLocalBroadcastReceiver.unregister();
                    LPMobileLog.d((String)TAG, (String)("Got Message Event notification for dialog id: " + QueryMessagesUMSCommand.this.dialogId + " conversation ID: " + QueryMessagesUMSCommand.this.conversationId + ". Sending callback finished successfully"));
                    if (intent.getBooleanExtra(MessagingEventSubscriptionManager.Companion.getSUCCESS(), false)) {
                        QueryMessagesUMSCommand.this.mResponseCallBack.onTaskSuccess();
                    } else {
                        QueryMessagesUMSCommand.this.mResponseCallBack.onTaskError(SocketTaskType.QUERY_MESSAGES, new Exception(intent.getStringExtra(MessagingEventSubscriptionManager.Companion.getERROR_MESSAGE())));
                    }
                }
            });
        }
        this.mLocalBroadcastReceiver.register();
    }
}

