/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.SendDocumentCommand;
import com.liveperson.messaging.model.MessagingChatMessage;

public class ReSendDocumentCommand
extends SendDocumentCommand {
    private long mFileRowId;
    private long mOriginalMessageTime;

    public ReSendDocumentCommand(Messaging controller, String targetId, String brandId, String contentType, String thumbnailPath, String filePath, String fileTypeExtension, MaskedMessage message, String previewContentType, String eventId, long originalMessageTime, long fileRowId) {
        super(controller, targetId, brandId, contentType, thumbnailPath, filePath, fileTypeExtension, message, previewContentType);
        this.mOriginalMessageTime = originalMessageTime;
        this.mFileRowId = fileRowId;
        this.mEventId = eventId;
    }

    @Override
    protected void addMessageToDBAndSend(String conversationId, MaskedMessage message) {
        this.mController.amsMessages.updateMessageState(this.mEventId, this.mTargetId, conversationId, MessagingChatMessage.MessageState.QUEUED);
        this.mController.amsMessages.getRowIdByEventId(this.mEventId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Long>(){

            public void onResult(Long data) {
                ReSendDocumentCommand.this.mMessageRowId = data;
                if (ReSendDocumentCommand.this.mCallback != null) {
                    ReSendDocumentCommand.this.mCallback.onFileAddedToDB(ReSendDocumentCommand.this.mMessageRowId, ReSendDocumentCommand.this.mFileRowId);
                }
            }
        }).execute();
    }

    @Override
    protected long getMessageTime() {
        return this.mOriginalMessageTime;
    }
}

