/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.text.TextUtils;
import com.liveperson.api.response.model.UserProfile;
import com.liveperson.api.response.types.TTRType;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.model.LPWelcomeMessage;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.liveperson.messaging.model.MessagingUserProfile;
import com.liveperson.messaging.network.http.AgentProfileRequest;

public class ConversationUtils {
    private static final String TAG = ConversationUtils.class.getSimpleName();
    protected final Messaging mController;

    public ConversationUtils(Messaging controller) {
        this.mController = controller;
    }

    public void addWelcomeMessage(String brandId, String message) {
        this.mController.amsMessages.isLastMessageWelcomeMessage().setPostQueryOnBackground(isLastMessageWelcomeMessage -> {
            long messageTimestamp = System.currentTimeMillis();
            MessagingChatMessage messagingChatMessage = this.buildWelcomeMessagingChatMessage(brandId, messageTimestamp, message);
            if (!isLastMessageWelcomeMessage.booleanValue()) {
                this.mController.amsMessages.addMessage(messagingChatMessage, true).execute();
            } else {
                this.mController.amsMessages.loadExistingWelcomeMessage(messagingChatMessage).execute();
            }
        }).execute();
    }

    public void updateWelcomeMessage(String brandId, LPWelcomeMessage message) {
        this.mController.amsMessages.isLastMessageWelcomeMessage().setPostQueryOnBackground(isLastMessageWelcomeMessage -> {
            if (isLastMessageWelcomeMessage.booleanValue()) {
                if (message.getMessageFrequency() == LPWelcomeMessage.MessageFrequency.FIRST_TIME_CONVERSATION) {
                    this.mController.amsMessages.removeLastWelcomeMessage().execute();
                } else {
                    long messageTimestamp = System.currentTimeMillis();
                    MessagingChatMessage messagingChatMessage = this.buildWelcomeMessagingChatMessage(brandId, messageTimestamp, message.getWelcomeMessage());
                    this.mController.amsMessages.updateLastWelcomeMessage(messagingChatMessage).execute();
                }
            }
        }).execute();
    }

    private MessagingChatMessage buildWelcomeMessagingChatMessage(String brandId, long messageTimestamp, String message) {
        String conversationId = "WELCOME_CONVERSATION_ID";
        String dialogId = "KEY_WELCOME_DIALOG_ID";
        String originatorId = "";
        String eventId = messageTimestamp + "_" + -4;
        this.mController.amsConversations.createDummyConversationForWelcomeMessage(brandId, conversationId, messageTimestamp);
        this.mController.amsDialogs.createDummyDialogForWelcomeMessage(brandId, conversationId, dialogId, -4L, messageTimestamp);
        MessagingChatMessage messagingChatMessage = new MessagingChatMessage(originatorId, message, messageTimestamp, dialogId, eventId, MessagingChatMessage.MessageType.BRAND, MessagingChatMessage.MessageState.RECEIVED, EncryptionVersion.NONE);
        messagingChatMessage.setServerSequence(-4);
        return messagingChatMessage;
    }

    public void updateParticipants(String targetId, String brandId, String[] participants, UserProfile.UserType userType, String conversationId, boolean updateUI, boolean forceUpdate) {
        this.updateParticipants(targetId, brandId, participants, userType, conversationId, updateUI, forceUpdate, null);
    }

    public void updateParticipants(final String targetId, final String brandId, String[] participants, final UserProfile.UserType userType, final String conversationId, final boolean updateUI, final boolean forceUpdate, final ICallback<MessagingUserProfile, Exception> callback) {
        for (final String userId : participants) {
            if (TextUtils.isEmpty((CharSequence)userId)) continue;
            this.mController.amsUsers.getUserById(userId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<MessagingUserProfile>(){

                public void onResult(MessagingUserProfile userProfile) {
                    if (userProfile == null) {
                        userProfile = new MessagingUserProfile("", "", userType);
                        userProfile.setOriginatorID(userId);
                        ConversationUtils.this.mController.amsUsers.updateUserProfile(userProfile);
                        LPMobileLog.i((String)TAG, (String)("First time bringing information for another participant that joined conversation " + conversationId));
                        ConversationUtils.this.sendUpdateUserRequest(targetId, brandId, userId, conversationId, updateUI, (ICallback<MessagingUserProfile, Exception>)callback);
                    } else if (userProfile.isEmptyUser() || forceUpdate) {
                        ConversationUtils.this.sendUpdateUserRequest(targetId, brandId, userId, conversationId, updateUI, (ICallback<MessagingUserProfile, Exception>)callback);
                    } else if (callback != null) {
                        callback.onSuccess((Object)userProfile);
                    }
                }
            }).execute();
        }
    }

    private void sendUpdateUserRequest(String targetId, String brandId, String userId, String conversationId, boolean shouldUpdateUi, ICallback<MessagingUserProfile, Exception> callback) {
        if (!TextUtils.isEmpty((CharSequence)userId)) {
            new AgentProfileRequest(this.mController, targetId, userId, conversationId, shouldUpdateUi).setCallback(callback).execute();
        } else {
            if (TextUtils.isEmpty((CharSequence)conversationId)) {
                LPMobileLog.d((String)TAG, (String)"sendUpdateUserRequest: no dialog id");
                return;
            }
            this.mController.amsConversations.queryConversationById(conversationId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Conversation>(){

                public void onResult(Conversation data) {
                    LPMobileLog.d((String)TAG, (String)"onResult: Calling agent details callback with null agent");
                    ConversationUtils.this.mController.onAgentDetailsChanged(null, data.isConversationOpen());
                }
            }).execute();
        }
    }

    public void updateTTR(TTRType type, long effectiveTTR, long delayTTR, String targetId) {
        LPMobileLog.d((String)TAG, (String)("update TTR type to - " + (Object)((Object)type) + ". EffectiveTTR = " + effectiveTTR));
        long clockDiff = this.mController.mConnectionController.getClockDiff(targetId);
        this.mController.amsConversations.updateTTRType(targetId, type, effectiveTTR, delayTTR, clockDiff);
    }

    public long calculateEffectiveTTR(String targetId, TTRType type, long ttrValue, long manualTTR, long delayTTR) {
        long clockDiff = this.mController.mConnectionController.getClockDiff(targetId);
        return this.mController.amsConversations.calculateEffectiveTTR(targetId, type, ttrValue, manualTTR, delayTTR, clockDiff);
    }

    public static void showTTR(Messaging controller, String targetId) {
        controller.amsConversations.showTTR(targetId);
    }
}

