/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.socket.requests;

import android.text.TextUtils;
import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.request.QueryMessages;
import com.liveperson.api.request.ReqBody;
import com.liveperson.api.response.events.ContentEventNotification;
import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.SocketTaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsSocketConnectionCallback;
import com.liveperson.messaging.network.socket.requests.NewConversationRequest;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class QueryMessagesRequest
extends BaseAMSSocketRequest<QueryMessages.Response, QueryMessagesRequest> {
    private static final String TAG = QueryMessagesRequest.class.getSimpleName();
    private final String mBrandId;
    private final Messaging mController;
    private String mDialogId;
    private int mMaxSize = -1;
    private int mNewerThanSequenceId;
    private int mOlderThanSequenceId = -1;
    private String mTargetId;
    private BaseAmsSocketConnectionCallback mConnectionCallback;
    private boolean mShouldUpdateUI = true;

    public QueryMessagesRequest(Messaging controller, String brandId, String targetId, String dialogId, int newerThanSequenceId) {
        super(controller.mAccountsController.getConnectionUrl(brandId));
        this.mController = controller;
        this.mBrandId = brandId;
        this.mTargetId = targetId;
        this.mDialogId = dialogId;
        this.mNewerThanSequenceId = newerThanSequenceId;
    }

    public void setResponseCallBack(BaseAmsSocketConnectionCallback callBack) {
        this.mConnectionCallback = callBack;
    }

    public QueryMessagesRequest setOlderThanSequenceId(int olderThanSequenceId) {
        this.mOlderThanSequenceId = olderThanSequenceId;
        return this;
    }

    public String getDialogId() {
        return this.mDialogId;
    }

    public QueryMessagesRequest setMaxSize(int maxSize) {
        this.mMaxSize = maxSize;
        return this;
    }

    public void setShouldUpdateUI(boolean shouldUpdateUI) {
        this.mShouldUpdateUI = shouldUpdateUI;
    }

    protected String getData() {
        this.onRequestSent();
        return new QueryMessages(this.mDialogId, this.mMaxSize, this.mOlderThanSequenceId, this.mNewerThanSequenceId + 1).toJsonString(this.getRequestId());
    }

    private void onRequestSent() {
        this.mController.amsDialogs.addUpdateRequestInProgress(this.mDialogId);
    }

    private void onRequestCompleted() {
        this.mController.amsDialogs.removeUpdateRequestInProgress(this.mDialogId);
    }

    protected String getRequestName() {
        return TAG;
    }

    protected BaseResponseHandler<QueryMessages.Response, QueryMessagesRequest> getResponseHandler() {
        return new BaseResponseHandler<QueryMessages.Response, QueryMessagesRequest>(){

            public BaseResponseHandler getResponseByExpectedType(String expectedType) {
                BaseResponseHandler supportedResponseHandler = this.getSupportedResponseHandler(expectedType);
                if (supportedResponseHandler != null) {
                    return supportedResponseHandler;
                }
                return this;
            }

            public String getAPIResponseType() {
                return ".ams.ms.QueryMessages$Response";
            }

            protected BaseResponseHandler getSupportedResponseHandler(String messageType) {
                if (TextUtils.equals((CharSequence)messageType, (CharSequence)"StringResponse")) {
                    return new BaseResponseHandler<ReqBody.StringResp, NewConversationRequest>(){

                        public String getAPIResponseType() {
                            return "StringResponse";
                        }

                        protected ReqBody.StringResp parse(JSONObject jsonObject) throws JSONException {
                            return new ReqBody.StringResp(jsonObject);
                        }

                        protected boolean handle(ReqBody.StringResp response) {
                            LPMobileLog.d((String)TAG, (String)("Received String response (" + response.code + ")."));
                            if (response.code > 201) {
                                LPMobileLog.w((String)TAG, (String)("Received bad query response (" + response.code + ")."));
                                if (QueryMessagesRequest.this.mConnectionCallback != null) {
                                    QueryMessagesRequest.this.mConnectionCallback.onTaskError(SocketTaskType.QUERY_MESSAGES, new Exception("response = " + response));
                                }
                                return true;
                            }
                            return false;
                        }
                    };
                }
                return super.getSupportedResponseHandler(messageType);
            }

            protected void giveUp() {
                super.giveUp();
                LPMobileLog.i((String)TAG, (String)(QueryMessagesRequest.this.getRequestId() + ": Request lost (socket closed) for query request."));
                if (QueryMessagesRequest.this.mConnectionCallback != null) {
                    QueryMessagesRequest.this.mConnectionCallback.onTaskError(SocketTaskType.QUERY_MESSAGES, new Exception("CloseSocket"));
                }
            }

            protected QueryMessages.Response parse(JSONObject jsonObject) throws JSONException {
                return new QueryMessages.Response(jsonObject);
            }

            protected boolean handle(QueryMessages.Response response) {
                LPMobileLog.d((String)TAG, (String)"Received query messages response");
                final String originatorId = QueryMessagesRequest.this.mController.getOriginatorId(QueryMessagesRequest.this.mTargetId);
                long clockDiff = ((QueryMessagesRequest)QueryMessagesRequest.this).mController.mConnectionController.getClockDiff(QueryMessagesRequest.this.mBrandId);
                if (((ArrayList)response.getBody()).size() == 0) {
                    DataBaseCommand<Boolean> command;
                    LPMobileLog.d((String)TAG, (String)"No messages in query response.");
                    if (QueryMessagesRequest.this.mOlderThanSequenceId == -1 && (command = ((QueryMessagesRequest)QueryMessagesRequest.this).mController.amsDialogs.updateLastServerSequenceByDialogId(QueryMessagesRequest.this.mDialogId, 0, 1, QueryMessagesRequest.this.mShouldUpdateUI)) != null) {
                        command.execute();
                    }
                    QueryMessagesRequest.this.onHandleResponseCompletedSuccessfully();
                    return true;
                }
                ContentEventNotification lastReceivedEvent = (ContentEventNotification)((ArrayList)response.getBody()).get(((ArrayList)response.getBody()).size() - 1);
                if (lastReceivedEvent != null) {
                    QueryMessagesRequest.this.mOlderThanSequenceId = lastReceivedEvent.sequence;
                }
                LPMobileLog.d((String)TAG, (String)(QueryMessagesRequest.this.getRequestId() + " Last sequence event received in query messages response - " + QueryMessagesRequest.this.mOlderThanSequenceId));
                DataBaseCommand<Boolean> command = ((QueryMessagesRequest)QueryMessagesRequest.this).mController.amsDialogs.updateLastServerSequenceByDialogId(QueryMessagesRequest.this.mDialogId, QueryMessagesRequest.this.mOlderThanSequenceId, QueryMessagesRequest.this.mOlderThanSequenceId - QueryMessagesRequest.this.mNewerThanSequenceId, QueryMessagesRequest.this.mShouldUpdateUI);
                if (command == null) {
                    LPMobileLog.d((String)TAG, (String)("Got unexpected QueryMessages!! query results last sequence = " + QueryMessagesRequest.this.mOlderThanSequenceId + ". ignoring query results!"));
                    QueryMessagesRequest.this.onHandleResponseCompletedFailed();
                } else {
                    command.setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Boolean>(){

                        public void onResult(Boolean isEventExpected) {
                            if (isEventExpected.booleanValue()) {
                                ((QueryMessagesRequest)QueryMessagesRequest.this).mController.amsMessages.sendReadAckOnMessages(QueryMessagesRequest.this.mBrandId, QueryMessagesRequest.this.mTargetId, originatorId);
                            } else {
                                LPMobileLog.d((String)TAG, (String)("Got unexpected QueryMessages!! query results last sequence = " + QueryMessagesRequest.this.mOlderThanSequenceId + ". ignoring query results!"));
                                QueryMessagesRequest.this.onHandleResponseCompletedFailed();
                            }
                        }
                    });
                    command.execute();
                }
                return true;
            }
        };
    }

    private void onHandleResponseCompletedFailed() {
        this.onRequestCompleted();
        if (this.mConnectionCallback != null) {
            this.mConnectionCallback.onTaskError(SocketTaskType.QUERY_MESSAGES, new Exception("unexpected QueryMessages"));
        }
    }

    private void onHandleResponseCompletedSuccessfully() {
        this.onRequestCompleted();
        if (this.mConnectionCallback != null) {
            this.mConnectionCallback.onTaskSuccess();
        }
    }
}

