/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.utils;

import android.content.Context;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.messaging.background.filesharing.FileSharingType;

public class FileSharingUtils {
    private static final String TAG = "FileSharingUtils";

    public static FileSharingType getFileSharingTypeFromUri(String uri, Context context) {
        try {
            Uri fileUri = Uri.parse((String)uri);
            String mimeType = context.getContentResolver().getType(fileUri);
            String extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType);
            return FileSharingType.getFileTypeFromExtension(extension);
        }
        catch (Exception e) {
            LPMobileLog.e((String)TAG, (String)"Failed to get file sharing type.", (Throwable)e);
            return null;
        }
    }

    public static boolean isDocumentType(FileSharingType fileType) {
        return fileType.getCommonFileType() == FileSharingType.CommonFileType.DOCUMENT;
    }
}

