package com.liveperson.messaging.background.filesharing.image;

import android.content.Context;
import android.webkit.MimeTypeMap;

import com.liveperson.infra.log.LPLog;

/**
 * Created by shiranr on 7/24/16.
 */
public class ReUploadImageTaskBundle extends UploadImageTaskBundle {
    private static final String TAG = "ReUploadImageTaskBundle";
    private String thumbnailLocalPath;
    private String eventId;
    private long originalMessageTime;
    private long fileRowId;

	public ReUploadImageTaskBundle build(int taskId, Context context){
		setTaskID(taskId);

		mFileTypeExtension = MimeTypeMap.getFileExtensionFromUrl(mFilePath).toUpperCase();
		mFileContentType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(mFileTypeExtension.toLowerCase());
		LPLog.INSTANCE.d(TAG, "build: mImageUri: " + mFileUri +" mImageTypeExtension = " + mFileTypeExtension +" mImageContentType = " + mFileContentType);
		return this;
	}

    public String getThumbnailLocalPath() {
        return thumbnailLocalPath;
    }


    public String getEventId() {
        return eventId;
    }

    public long getOriginalMessageTime() {
        return originalMessageTime;
    }


    public long getFileRowId() {
        return fileRowId;
    }


    public ReUploadImageTaskBundle addFileRowId(long fileRowId) {
        this.fileRowId = fileRowId;
        return this;
    }
    public ReUploadImageTaskBundle addThumbnailLocalPath(String thumbnailLocalUriPath) {
        this.thumbnailLocalPath = thumbnailLocalUriPath;
        return this;
    }
    public ReUploadImageTaskBundle addEventID(String eventId) {
        this.eventId = eventId;
        return this;
    }
    public ReUploadImageTaskBundle addOriginalMessageTime(long originalMessageTime) {
        this.originalMessageTime = originalMessageTime;
        return this;
    }

    public ReUploadImageTaskBundle addOriginalLocalPath(String originalImagePath) {
        mFilePath = originalImagePath;
        return this;
    }
}
