package com.liveperson.messaging.controller.connection;

import com.liveperson.infra.statemachine.interfaces.IEvent;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionCallback;
import com.liveperson.infra.statemachine.interfaces.IStateMachine;
import com.liveperson.messaging.controller.connection.connectionevents.SecondaryTaskSuccessEvent;
import com.liveperson.messaging.controller.connection.connectionevents.TaskFailedEvent;
import com.liveperson.messaging.controller.connection.connectionevents.TaskSuccessEvent;

/**
 * Created by shiranr on 14/03/2016.
 */
class DefaultTaskCallbackAmsAccount implements BaseAmsAccountConnectionCallback {

    private IStateMachine mStateMachine;
    protected String mTaskName;
    private boolean mSecondaryTask = false;

    public DefaultTaskCallbackAmsAccount(IStateMachine stateMachine, String taskName) {
        mStateMachine = stateMachine;
        mTaskName = taskName;
    }

    @Override
    public void onTaskSuccess() {

        IEvent taskToSend;

        if (mSecondaryTask) {
            taskToSend = new SecondaryTaskSuccessEvent(mTaskName);
        } else {
            taskToSend = new TaskSuccessEvent(mTaskName);

        }

        mStateMachine.postEvent(taskToSend);

    }


    @Override
    public void onTaskError(final TaskType type, final Exception exception) {
        mStateMachine.postEvent(new TaskFailedEvent(mTaskName, type, exception));
    }

    public void setSecondaryTask(boolean secondaryTask) {
        mSecondaryTask = secondaryTask;
    }
}