package com.liveperson.messaging.model;


import com.liveperson.api.exception.BadConversationException;
import com.liveperson.api.response.model.ConversationINCADetails;
import com.liveperson.infra.log.LPLog;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

/**
 * Created by shiranr on 1/14/18.
 */

public class IncaGetConversationsListResponse {
    private static final String TAG = "IncaGetConversationsListResponse";
    public String mNextUrl;
    private int mCount = 0;
    private ArrayList<ConversationINCADetails> listOfConversations = null;

    public IncaGetConversationsListResponse(String response) {

        try {
            JSONObject responseJson = new JSONObject(response);
            if (!responseJson.has("_responseMetadata")) {
                LPLog.INSTANCE.d(TAG, "Missing _responseMetadata field. This could be a new user.");
                return;
            }
            JSONObject responseMetadataJson = responseJson.getJSONObject("_responseMetadata");

            mCount = responseMetadataJson.optInt("count");
            JSONObject next = responseMetadataJson.optJSONObject("next");
            if (next != null){
                mNextUrl = next.optString("href");
            }

            JSONArray conversationList = responseJson.getJSONArray("conversationHistoryMetadataRecords");

            JSONObject conversation;
            listOfConversations = new ArrayList<>(conversationList.length());
            for (int i = 0; i < conversationList.length() ; i++){
                conversation = conversationList.getJSONObject(i);
                try {
                    listOfConversations.add(new ConversationINCADetails(conversation));
                } catch (BadConversationException e) {
                    LPLog.INSTANCE.w(TAG, "Failed to create new ConversationINCADetails from conversation: " + LPLog.INSTANCE.mask(conversation), e);
                }
            }

        } catch (JSONException e) {
            LPLog.INSTANCE.e(TAG, "Failed to parse INCA response details.", e);
        }

    }

    public ArrayList<ConversationINCADetails> getListOfConversations() {
        return listOfConversations;
    }

    public int getNumOfResults() {
        return mCount;
    }
}


/*
{
  "_responseMetadata": {
    "count": 9,
    "self": {
      "rel": "self",
      "href": "https://va-a.msghist.liveperson.net/messaging_history/api/account/36366796/conversations/consumer/metadata/search?state=close&startFrom=1482021733329&startTo=1516092133308&limit=100&offset=0&sort=start:desc"
    },
    "shardsStatusResult": {
      "partialResult": false
    }
  },
  "conversationHistoryMetadataRecords": [
    {
      "convId": "145e7d23-ecd8-4ead-a3c1-e6a0b0d999ae",
      "participants": [
        {
          "id": "a44b8fb5e565dea916e1f3bd50cd0e5fc3cd992f38cf77da0a3966d399a5d11b",
          "role": "CONSUMER"
        },
        {
          "id": "86aece85-c4af-545c-8793-3b40a973ae84",
          "role": "ASSIGNED_AGENT"
        }
      ],
      "state": "CLOSE",
      "startTs": 1515401555951,
      "endTs": 1515402857709,
      "csat": {
        "csatRate": 4.0,
        "csatResolutionConfirmation": false,
        "status": "PARTIALLY_FILLED"
      }
    },
    {
      "convId": "5b6e9761-539e-432b-9a3a-9af514751670",
      "participants": [
        {
          "id": "a44b8fb5e565dea916e1f3bd50cd0e5fc3cd992f38cf77da0a3966d399a5d11b",
          "role": "CONSUMER"
        },
        {
          "id": "86aece85-c4af-545c-8793-3b40a973ae84",
          "role": "ASSIGNED_AGENT"
        }
      ],
      "state": "CLOSE",
      "startTs": 1514982029976,
      "endTs": 1515333374618
    },
    {
      "convId": "e2fd2595-47e0-449f-89b5-1c948b13094d",
      "participants": [
        {
          "id": "a44b8fb5e565dea916e1f3bd50cd0e5fc3cd992f38cf77da0a3966d399a5d11b",
          "role": "CONSUMER"
        },
        {
          "id": "fe2945f6-c149-592c-bd04-02cf3461b8ba",
          "role": "ASSIGNED_AGENT"
        }
      ],
      "state": "CLOSE",
      "startTs": 1514966597392,
      "endTs": 1514982021341,
      "csat": {
        "csatRate": 5.0,
        "csatResolutionConfirmation": false,
        "status": "PARTIALLY_FILLED"
      }
    },
    {
      "convId": "a93d3b69-6577-499a-923a-916da544b0c9",
      "participants": [
        {
          "id": "a44b8fb5e565dea916e1f3bd50cd0e5fc3cd992f38cf77da0a3966d399a5d11b",
          "role": "CONSUMER"
        },
        {
          "id": "86aece85-c4af-545c-8793-3b40a973ae84",
          "role": "ASSIGNED_AGENT"
        }
      ],
      "state": "CLOSE",
      "startTs": 1514884343266,
      "endTs": 1514887310578
    },
    {
      "convId": "d6168e2f-66d5-44c3-b550-dbe19601a5a0",
      "participants": [
        {
          "id": "a44b8fb5e565dea916e1f3bd50cd0e5fc3cd992f38cf77da0a3966d399a5d11b",
          "role": "CONSUMER"
        },
        {
          "id": "0d434914-f0d2-5d71-9476-b6686847a733",
          "role": "ASSIGNED_AGENT"
        }
      ],
      "state": "CLOSE",
      "startTs": 1514884164787,
      "endTs": 1514884184350,
      "csat": {
        "csatRate": 4.0,
        "csatResolutionConfirmation": false,
        "status": "PARTIALLY_FILLED"
      }
    },
    {
      "convId": "2099f9e9-f8b0-4583-bb8c-f7af41a9acc7",
      "participants": [
        {
          "id": "a44b8fb5e565dea916e1f3bd50cd0e5fc3cd992f38cf77da0a3966d399a5d11b",
          "role": "CONSUMER"
        },
        {
          "id": "86aece85-c4af-545c-8793-3b40a973ae84",
          "role": "ASSIGNED_AGENT"
        },
        {
          "id": "0d434914-f0d2-5d71-9476-b6686847a733",
          "role": "READER"
        },
        {
          "id": "86aece85-c4af-545c-8793-3b40a973ae84",
          "role": "ASSIGNED_AGENT"
        },
        {
          "id": "86aece85-c4af-545c-8793-3b40a973ae84",
          "role": "READER"
        },
        {
          "id": "0d434914-f0d2-5d71-9476-b6686847a733",
          "role": "ASSIGNED_AGENT"
        }
      ],
      "state": "CLOSE",
      "startTs": 1514883893896,
      "endTs": 1514884144553,
      "csat": {
        "csatRate": 4.0,
        "csatResolutionConfirmation": false,
        "status": "PARTIALLY_FILLED"
      }
    },
    {
      "convId": "c52b143f-d886-41d4-b5c3-c925b0ae7cf1",
      "participants": [
        {
          "id": "a44b8fb5e565dea916e1f3bd50cd0e5fc3cd992f38cf77da0a3966d399a5d11b",
          "role": "CONSUMER"
        },
        {
          "id": "86aece85-c4af-545c-8793-3b40a973ae84",
          "role": "READER"
        },
        {
          "id": "86aece85-c4af-545c-8793-3b40a973ae84",
          "role": "MANAGER"
        },
        {
          "id": "0d434914-f0d2-5d71-9476-b6686847a733",
          "role": "ASSIGNED_AGENT"
        }
      ],
      "state": "CLOSE",
      "startTs": 1514882123686,
      "endTs": 1514883874659,
      "csat": {
        "csatRate": 4.0,
        "csatResolutionConfirmation": false,
        "status": "PARTIALLY_FILLED"
      }
    },
    {
      "convId": "1f250a38-720c-4ae0-950b-c70c1fdc4d32",
      "participants": [
        {
          "id": "a44b8fb5e565dea916e1f3bd50cd0e5fc3cd992f38cf77da0a3966d399a5d11b",
          "role": "CONSUMER"
        },
        {
          "id": "86aece85-c4af-545c-8793-3b40a973ae84",
          "role": "READER"
        },
        {
          "id": "86aece85-c4af-545c-8793-3b40a973ae84",
          "role": "MANAGER"
        }
      ],
      "state": "CLOSE",
      "startTs": 1511991321850,
      "endTs": 1511995991529
    },
    {
      "convId": "e548864a-6e36-4ad0-aa3b-7e739d655a64",
      "participants": [
        {
          "id": "a44b8fb5e565dea916e1f3bd50cd0e5fc3cd992f38cf77da0a3966d399a5d11b",
          "role": "CONSUMER"
        },
        {
          "id": "86aece85-c4af-545c-8793-3b40a973ae84",
          "role": "ASSIGNED_AGENT"
        },
        {
          "id": "d95a0e76-39f6-54e2-ad5c-3ed1ec660666",
          "role": "READER"
        },
        {
          "id": "0d434914-f0d2-5d71-9476-b6686847a733",
          "role": "READER"
        }
      ],
      "state": "CLOSE",
      "startTs": 1487595328706,
      "endTs": 1499065829128
    }
  ]
}

 */
