package com.liveperson.messaging.structuredcontent.model.elements.complex;

import com.liveperson.messaging.structuredcontent.model.elements.BaseElement;
import com.liveperson.messaging.structuredcontent.parsers.ElementType;
import com.liveperson.messaging.structuredcontent.visitor.ElementVisitor;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by nirni on 3/6/18.
 */

public class CarouselElement extends ComplexElement {

	private int mPadding;

	public CarouselElement(JSONObject jsonObject) throws JSONException {
		super(jsonObject);

		mPadding = jsonObject.optInt(ElementType.PADDING, 0);
	}

	@Override
	public void accept(ElementVisitor visitor) {

		visitor.visit(this);
	}

	@Override
	public String toString() {

		StringBuilder sb = new StringBuilder();
		sb.append(getClass().getSimpleName() + "{\n");
		sb.append("Elements[\n");
		if( mElementList != null ) {
			for (BaseElement baseElement : mElementList) {
				sb.append(baseElement.toString());
			}
		}
		sb.append("]\n");
		sb.append("}\n");
		return sb.toString();

	}

	public int getPadding() {
		return mPadding;
	}

	public void setPadding(int padding) {
		mPadding = padding;
	}
}
