/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.response.events;

import android.text.TextUtils;
import com.liveperson.api.exception.BadMessageException;
import com.liveperson.api.response.model.Event;
import com.liveperson.api.response.model.OriginatorMetadata;
import org.json.JSONException;
import org.json.JSONObject;

public class ContentEventNotification {
    public int sequence;
    public String originatorId;
    public long serverTimestamp;
    public Event event;
    public String dialogId;
    public String eventId;
    public OriginatorMetadata originatorMetadata;

    public ContentEventNotification(JSONObject jsonObject) throws JSONException, BadMessageException {
        String originatorPId;
        this.sequence = jsonObject.optInt("sequence", -1);
        this.originatorId = jsonObject.optString("originatorId");
        String string = originatorPId = jsonObject.isNull("originatorPId") ? null : jsonObject.optString("originatorPId");
        if (!TextUtils.isEmpty((CharSequence)originatorPId)) {
            this.originatorId = originatorPId;
        }
        this.serverTimestamp = jsonObject.optLong("serverTimestamp");
        this.dialogId = jsonObject.optString("dialogId");
        this.eventId = jsonObject.isNull("eventId") ? null : jsonObject.optString("eventId");
        JSONObject event = jsonObject.optJSONObject("event");
        if (event == null) {
            this.event = null;
            return;
        }
        this.event = new Event(event);
        this.originatorMetadata = OriginatorMetadata.fromJson(jsonObject.optJSONObject("originatorMetadata"));
    }

    public String toString() {
        return this.event.toString();
    }
}

