/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.requests.CSDSRequest;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionTask;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.model.AmsConnectionAnalytics;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;

public class CsdsTask
extends BaseAmsAccountConnectionTask {
    private static final String TAG = "CsdsTask";
    private final AccountsController mAccountsController;

    public CsdsTask(AccountsController accountsController) {
        this.mAccountsController = accountsController;
    }

    public void execute() {
        LPLog.INSTANCE.d(TAG, "Running CSDS task...");
        AmsConnectionAnalytics.csdsTaskStart();
        String domain = this.mAccountsController.getDomain(this.mBrandId);
        List<String> certificates = this.mAccountsController.getCertificatePinningKeys(this.mBrandId);
        new CSDSRequest(domain, this.mBrandId, certificates, (ICallback)new ICallback<HashMap<String, String>, Exception>(){

            public void onSuccess(HashMap<String, String> cSDSUrls) {
                if (CsdsTask.this.mAccountsController.setCSDSMap(CsdsTask.this.mBrandId, cSDSUrls)) {
                    LPLog.INSTANCE.d(CsdsTask.TAG, "onSuccess: One of the CSDS values had changed. Return error");
                    AmsConnectionAnalytics.csdsTaskEnd();
                    CsdsTask.this.mCallback.onTaskError(TaskType.CSDS, new Exception("New CSDS values were set."));
                    return;
                }
                AmsConnectionAnalytics.csdsTaskEnd();
                CsdsTask.this.mCallback.onTaskSuccess();
            }

            public void onError(Exception e) {
                if (e instanceof SSLPeerUnverifiedException) {
                    CsdsTask.this.mCallback.onTaskError(TaskType.INVALID_CERTIFICATE, e);
                } else {
                    CsdsTask.this.mCallback.onTaskError(TaskType.CSDS, e);
                }
            }
        }).execute();
    }

    @Override
    public String getName() {
        return TAG;
    }
}

