/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import com.liveperson.api.exception.BadConversationException;
import com.liveperson.api.response.model.ConversationINCADetails;
import com.liveperson.infra.log.LPLog;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class IncaGetConversationsListResponse {
    private static final String TAG = "IncaGetConversationsListResponse";
    public String mNextUrl;
    private int mCount = 0;
    private ArrayList<ConversationINCADetails> listOfConversations = null;

    public IncaGetConversationsListResponse(String response) {
        try {
            JSONObject responseJson = new JSONObject(response);
            if (!responseJson.has("_responseMetadata")) {
                LPLog.INSTANCE.d(TAG, "Missing _responseMetadata field. This could be a new user.");
                return;
            }
            JSONObject responseMetadataJson = responseJson.getJSONObject("_responseMetadata");
            this.mCount = responseMetadataJson.optInt("count");
            JSONObject next = responseMetadataJson.optJSONObject("next");
            if (next != null) {
                this.mNextUrl = next.optString("href");
            }
            JSONArray conversationList = responseJson.getJSONArray("conversationHistoryMetadataRecords");
            this.listOfConversations = new ArrayList(conversationList.length());
            for (int i = 0; i < conversationList.length(); ++i) {
                JSONObject conversation = conversationList.getJSONObject(i);
                try {
                    this.listOfConversations.add(new ConversationINCADetails(conversation));
                    continue;
                }
                catch (BadConversationException e) {
                    LPLog.INSTANCE.w(TAG, "Failed to create new ConversationINCADetails from conversation: " + LPLog.INSTANCE.mask((Object)conversation), (Throwable)e);
                }
            }
        }
        catch (JSONException e) {
            LPLog.INSTANCE.e(TAG, "Failed to parse INCA response details.", (Throwable)e);
        }
    }

    public ArrayList<ConversationINCADetails> getListOfConversations() {
        return this.listOfConversations;
    }

    public int getNumOfResults() {
        return this.mCount;
    }
}

