package com.liveperson.api.request;

import com.liveperson.api.response.model.UserProfile;
import com.liveperson.api.response.AbstractResponse;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Shayl on 8/9/2015.
 */
public class GetUserProfile extends AbstractRequest {

    private static final String BODY = "body";
    private static final String GET_USER_PROFILE_TYPE = "userprofile.GetUserProfile";
    private String body;

    public GetUserProfile(String body) {
        super();
        this.body = body;
    }

    @Override
    public String getMessageType() {
        return GET_USER_PROFILE_TYPE;
    }

    @Override
    protected void toJson(JSONObject json) throws JSONException {
        json.put(AbstractRequest.JSON_KEY_BODY, body);
    }


    public static class Response extends AbstractResponse<UserProfile> {
        public static final String GET_USER_PROFILE_RESPONSE_TYPE = "userprofile.GetUserProfileResponse";

        UserProfile body;

        public Response(JSONObject obj) throws JSONException {
            super(obj);
            body = new UserProfile(obj.getJSONObject(BODY));
        }

        public UserProfile getBody() {
            return body;
        }
    }
}
