package com.liveperson.api.response.model;

import org.json.JSONObject;

/**
 * Created by cgiehl on 8/10/15.
 */
public class CobrowseDialogData extends DialogData {

    public final String metaData;

    protected CobrowseDialogData(JSONObject jsonObject, String conversationId) {
        super(jsonObject, conversationId);

        if (!ChannelType.COBROWSE.equals(channelType)) {
            throw new IllegalArgumentException("Channel passed to CobrowseDialogData was not ChannelType.COBROWSE!");
        }

        JSONObject jsonMeta = jsonObject.optJSONObject("metaData");
        metaData = (null != jsonMeta) ? jsonMeta.toString() : null;
    }

}
