package com.liveperson.messaging.commands;

import com.liveperson.api.request.GenerateUploadTokenRequest;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.SocketManager;


/**
 * Created by Maayan on 9/3/2017
 * A command for generating token for secure form
 */
public class SendGenerateUploadTokenCommand implements Command {

	private static final String TAG = "SendGenUploadTokenCmd";

	private String mDialogId;
	private String mFormId;
	private String mInvitationId;
	private String mSocketUrl;
	private ICallback<Object, Throwable> mCallback;


	/**
	 * Creates a command for sending messages
	 */
	public SendGenerateUploadTokenCommand(String socketUrl,
										  String formId,
										  String dialogId,
										  String invitationId,
										  ICallback<Object, Throwable> callback) {

		mSocketUrl = socketUrl;
		mDialogId = dialogId;
		mFormId = formId;
		mInvitationId = invitationId;
		mCallback = callback;
	}

	@Override
	public void execute() {
		GenerateUploadTokenRequest baseSocketRequest = new GenerateUploadTokenRequest(mSocketUrl, mDialogId, mFormId, mInvitationId);
		baseSocketRequest.setResponseCallBack(new ICallback<Object, Throwable>() {
			@Override
			public void onSuccess(Object value) {
				mCallback.onSuccess(value);
				LPLog.INSTANCE.d(TAG, "onSuccess with value: "+value);
			}

			@Override
			public void onError(Throwable exception) {
				LPLog.INSTANCE.w(TAG, "an error in parsing", exception);
				mCallback.onError(exception);
			}
		});
		SocketManager.getInstance().send(baseSocketRequest);
	}
}
