package com.liveperson.messaging.commands.tasks;

import com.liveperson.infra.ICallback;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.SocketTaskType;
import com.liveperson.messaging.commands.BasicQueryMessagesCommand;
import com.liveperson.messaging.model.Dialog;

import java.util.ArrayList;

public class UpdateEmptyDialogCommand extends BasicQueryMessagesCommand {

    public UpdateEmptyDialogCommand(Messaging controller, String brandId, String conversationId, String dialogId, boolean updateUI) {
        super(controller, brandId, conversationId, dialogId, updateUI);
    }

    @Override
    public void execute() {
        controller.amsDialogs.saveMessagesResult(dialogId, new ArrayList<>(), true, mUpdateUI, new ICallback<Dialog, Exception>() {
            @Override
            public void onSuccess(Dialog value) {
                if (mResponseCallBack != null){
                    mResponseCallBack.onTaskSuccess();
                }
            }

            @Override
            public void onError(Exception exception) {
                if (mResponseCallBack != null){
                    mResponseCallBack.onTaskError(SocketTaskType.QUERY_MESSAGES, new Exception("unexpected QueryMessages"));
                }
            }
        });
    }
}
