package com.liveperson.messaging.structuredcontent.model.elements.basic;

import com.liveperson.messaging.structuredcontent.model.elements.ActionableElement;
import com.liveperson.messaging.structuredcontent.parsers.ElementType;
import com.liveperson.messaging.structuredcontent.visitor.ElementVisitor;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by nirni on 2/2/17.
 * Button element. Holds a title property
 */
public class ButtonElement extends ActionableElement {

	private ElementStyle mStyle;

	/**
	 * The title of the button
	 */
	private String mTitle;
	private boolean isLink;

	/**
	 * This sets title of the button from the given json.
	 * @param jsonObject
	 * @throws JSONException
	 */
	public ButtonElement(JSONObject jsonObject) throws JSONException {
		super(jsonObject);
		mTitle = (String) jsonObject.get(ElementType.TITLE);
		JSONObject style = jsonObject.optJSONObject(ElementType.STYLE); //Optional
		mStyle = new ElementStyle(style);
		JSONObject clickObject = jsonObject.optJSONObject(ElementType.CLICK);
		if (clickObject != null) {
			JSONArray actionArray = clickObject.optJSONArray(ElementType.ACTIONS);
			if (actionArray != null) {
				for (int i = 0; i < actionArray.length(); i++) {
					JSONObject actionObject = actionArray.getJSONObject(i);
					if (ElementType.LINK.equals(actionObject.getString(ElementType.TYPE))) {
						isLink = true;
						break;
					}
				}
			}
		}
	}

	@Override
	public String toString() {

		StringBuilder sb = new StringBuilder();
		sb.append(getClass().getSimpleName() + " - " + mTitle + "\n");

		return sb.toString();
	}

	@Override
	public void accept(ElementVisitor visitor) {
		visitor.visit(this);
	}

	public String getTitle() {
		return mTitle;
	}

	public void setTitle(String title) {
		mTitle = title;
	}

	public ElementStyle getStyle() {
		return mStyle;
	}

	public boolean isLink() {
		return isLink;
	}
}
