/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.response.model;

import android.webkit.URLUtil;
import com.liveperson.api.exception.BadMessageException;
import com.liveperson.api.request.message.BasePublishMessage;
import com.liveperson.api.request.message.FilePublishMessage;
import com.liveperson.api.request.message.FormPublishMessage;
import com.liveperson.api.request.message.FormSubmissionPublishMessage;
import com.liveperson.api.request.message.JsonPublishMessage;
import com.liveperson.api.request.message.StructuredContentPublishMessage;
import com.liveperson.api.request.message.TextPublishMessage;
import com.liveperson.api.response.model.ContentType;
import com.liveperson.api.response.types.DeliveryStatus;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.types.ChatState;
import com.liveperson.messaging.MessagingFactory;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Event {
    private static final String TAG = "Event";
    private static final String CONTENT = "content";
    public Types type;
    public String contentType;
    public BasePublishMessage message;
    public ChatState chatState;
    public DeliveryStatus status;
    public int[] sequenceList;
    public String quickRepliesJsonString;

    private String[] extractLinks(String text) {
        text = text.replaceAll("\u200b", "");
        text = text.replaceAll("\u200c", "");
        text = text.replaceAll("\u200d", "");
        text = text.replaceAll("\ufeff", "");
        text = text.trim();
        text = text.replaceAll("\n", "");
        ArrayList<String> links = new ArrayList<String>();
        String[] l = text.split("\\s+");
        for (int i = 0; i < l.length; ++i) {
            if (!URLUtil.isValidUrl((String)l[i])) continue;
            links.add(l[i]);
        }
        return links.toArray(new String[links.size()]);
    }

    public Event(JSONObject jsonObject) throws JSONException, BadMessageException {
        if (jsonObject == null) {
            LPLog.INSTANCE.w(TAG, "No EVENT content!");
            return;
        }
        this.type = Types.valueOf(jsonObject.getString("type"));
        switch (this.type) {
            case AcceptStatusEvent: {
                String statusString = jsonObject.optString("status");
                try {
                    this.status = DeliveryStatus.valueOf(statusString);
                }
                catch (IllegalArgumentException e) {
                    throw new BadMessageException("Bad Accept Status: " + statusString);
                }
                JSONArray list = jsonObject.optJSONArray("sequenceList");
                if (list == null) {
                    list = new JSONArray();
                }
                this.sequenceList = new int[list.length()];
                for (int i = 0; i < list.length(); ++i) {
                    this.sequenceList[i] = list.getInt(i);
                }
                break;
            }
            case ChatStateEvent: {
                String chatStateString = jsonObject.optString("chatState", "GONE");
                this.chatState = ChatState.valueOf((String)chatStateString);
                break;
            }
            case ContentEvent: {
                this.contentType = jsonObject.optString("contentType");
                ContentType contentTypeEnum = ContentType.fromString(this.contentType);
                if (contentTypeEnum.isFile()) {
                    JSONObject messageObject = jsonObject.optJSONObject("message");
                    if (messageObject != null) {
                        LPLog.INSTANCE.d(TAG, "Event: parsing file message");
                        this.message = new FilePublishMessage(messageObject);
                    }
                } else if (contentTypeEnum.isSimpleText()) {
                    String str = jsonObject.optString("message");
                    String[] urls = this.extractLinks(str);
                    if (urls.length <= 0) {
                        this.message = new TextPublishMessage(jsonObject.optString("message"));
                    } else {
                        LPLog.INSTANCE.d(TAG, "Event: parsing url message");
                        this.message = new JsonPublishMessage(str, urls[0]);
                    }
                } else if (contentTypeEnum.isFormInvitation()) {
                    JSONObject messageObject = jsonObject.optJSONObject("message");
                    if (messageObject != null) {
                        LPLog.INSTANCE.d(TAG, "Event: parsing form invitation message");
                        this.message = new FormPublishMessage(messageObject);
                    }
                } else if (contentTypeEnum.isFormSubmission()) {
                    JSONObject messageObject = jsonObject.optJSONObject("message");
                    if (messageObject != null) {
                        LPLog.INSTANCE.d(TAG, "Event: parsing form Submission message");
                        this.message = new FormSubmissionPublishMessage(messageObject);
                    }
                } else {
                    LPLog.INSTANCE.w(TAG, "Event: received an unsupported message type");
                    this.message = new TextPublishMessage("Message Type Not supported");
                }
                this.parseQuickReplies(jsonObject);
                break;
            }
            case RichContentEvent: {
                if (MessagingFactory.getInstance().getController().isEnableStructuredContent()) {
                    LPLog.INSTANCE.d(TAG, "Event: parsing RichContentEvent");
                    this.message = new StructuredContentPublishMessage(jsonObject.optString(CONTENT));
                    this.parseQuickReplies(jsonObject);
                    break;
                }
                LPLog.INSTANCE.d(TAG, "Event: got RichContentEvent but was not parsed since the feature is disabled in branding");
            }
        }
    }

    private void parseQuickReplies(JSONObject jsonObject) {
        JSONObject quickRepliesJsonObject = jsonObject.optJSONObject("quickReplies");
        if (quickRepliesJsonObject != null) {
            this.quickRepliesJsonString = quickRepliesJsonObject.toString();
        }
    }

    public static enum Types {
        AcceptStatusEvent,
        ChatStateEvent,
        ContentEvent,
        RichContentEvent;

    }
}

