/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.text.TextUtils;
import com.liveperson.infra.log.LPLog;
import org.json.JSONException;
import org.json.JSONObject;

public class AcUserData {
    private static final String TAG = "AcUserData";
    private static final String KEY_PICTURE_URL = "pictureUrl";
    private static final String KEY_NICKNAME = "nickname";
    private static final String KEY_FULLNAME = "fullName";
    private static final String KEY_EMPLOYEE_ID = "employeeId";
    private static final String KEY_EMAIL = "email";
    private String mPictureUrl;
    private String mNickName;
    private String mFullName;
    private String mFirstName;
    private String mLastName;
    private String mEmployeeId;
    private String mEmail;

    public AcUserData(String profileStr) {
        try {
            JSONObject profileObj = new JSONObject(profileStr);
            this.mPictureUrl = profileObj.optString(KEY_PICTURE_URL);
            this.mNickName = profileObj.optString(KEY_NICKNAME);
            this.mFirstName = "";
            this.mLastName = "";
            this.mFullName = profileObj.optString(KEY_FULLNAME);
            if (!TextUtils.isEmpty((CharSequence)this.mFullName)) {
                String[] splitName = this.mFullName.split("\\s+");
                this.mFirstName = splitName[0];
                if (splitName.length >= 2) {
                    this.mLastName = splitName[1];
                }
            }
            this.mEmployeeId = profileObj.optString(KEY_EMPLOYEE_ID);
            this.mEmail = profileObj.optString(KEY_EMAIL);
        }
        catch (JSONException je) {
            LPLog.INSTANCE.e(TAG, "JSONException", (Throwable)je);
        }
    }

    public String getPictureUrl() {
        return this.mPictureUrl;
    }

    public String getNickName() {
        return this.mNickName;
    }

    public String getFullName() {
        return this.mFullName;
    }

    public String getEmployeeId() {
        return this.mEmployeeId;
    }

    public String getEmail() {
        return this.mEmail;
    }

    public String getFirstName() {
        return this.mFirstName;
    }

    public String getLastName() {
        return this.mLastName;
    }
}

