/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.http;

import android.os.Build;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.auth.LPAuthenticationType;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.body.HttpRequestBody;
import com.liveperson.infra.network.http.body.LPJSONObjectBody;
import com.liveperson.infra.network.http.request.HttpPostRequest;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.commands.tasks.IdpTask;
import com.liveperson.messaging.model.AmsAccount;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.json.JSONException;
import org.json.JSONObject;

public class IdpRequest
implements Command {
    private static final String TAG = "IdpRequest";
    protected static final int IDP_REQUEST_TIMEOUT = 30000;
    protected static final String SIGNUP = "signup";
    protected static final String AUTHENTICATE = "authenticate";
    protected static final String DEFAULT_REDIRECT_URI = "https://liveperson.net";
    public static final String USER_EXPIRED_ERROR = "2001";
    private static final String IDP_URL = "https://%s/api/account/%s/app/default/%s?v=2.0";
    protected final AmsAccount mAccount;
    protected String mIdpDomain;
    protected String mBrandId;
    protected IdpTask.IDPExceptionICallback mCallback;
    private LPAuthenticationParams mLPAuthenticationParams;
    private String mHostVersion;
    private List<String> mCertificates;

    public IdpRequest(AmsAccount account, String idpDomain, String brandId, LPAuthenticationParams lpAuthenticationParams, String hostVersion, IdpTask.IDPExceptionICallback callback, List<String> certificates) {
        this.mIdpDomain = idpDomain;
        this.mBrandId = brandId;
        this.mCallback = callback;
        this.mHostVersion = hostVersion;
        this.mCertificates = certificates;
        this.mAccount = account;
        this.mLPAuthenticationParams = lpAuthenticationParams;
    }

    public void execute() {
        LPAuthenticationType authType = LPAuthenticationType.UN_AUTH;
        if (this.mLPAuthenticationParams != null) {
            authType = this.mLPAuthenticationParams.getAuthType();
        }
        switch (authType) {
            case AUTH: {
                String hostAppJWT = this.mLPAuthenticationParams.getHostAppJWT();
                String authKey = this.mLPAuthenticationParams.getAuthKey();
                if (TextUtils.isEmpty((CharSequence)hostAppJWT) && TextUtils.isEmpty((CharSequence)authKey)) {
                    LPLog.INSTANCE.e(TAG, "execute: both hostAppJWT and authKey are empty. Cannot continue");
                    this.sendErrorCallback(new Exception("No JWT nor authKey was provided to AUTH authentication. Cannot authenticate"));
                    return;
                }
                this.sendGeneralRequest(this.getHttpPostRequestForIDPV2(hostAppJWT, authKey));
                break;
            }
            case UN_AUTH: {
                break;
            }
            default: {
                this.sendGeneralRequest(this.getHttpPostRequestForSignUp());
            }
        }
    }

    protected void sendErrorCallback(Exception exception) {
        LPLog.INSTANCE.e(TAG, "Sending error callback.", (Throwable)exception);
        if (exception instanceof SSLPeerUnverifiedException) {
            this.mCallback.onError(TaskType.INVALID_CERTIFICATE, exception);
        } else {
            this.mCallback.onError(TaskType.IDP, exception);
        }
    }

    protected void sendGeneralRequest(HttpPostRequest httpPostRequest) {
        if (httpPostRequest != null) {
            httpPostRequest.setCertificatePinningKeys(this.mCertificates);
            LPLog.INSTANCE.d(TAG, "IDP request url : " + httpPostRequest.getUrl());
            httpPostRequest.setTimeout(30000);
            this.addHeaders(httpPostRequest);
            HttpHandler.execute((HttpRequest)httpPostRequest);
        }
    }

    @NonNull
    private HttpPostRequest getHttpPostRequestForIDPV2(String hostAppJWT, String authKey) {
        JSONObject jsonBody = null;
        if (!TextUtils.isEmpty((CharSequence)hostAppJWT)) {
            jsonBody = this.getBodyForIDPJwtFlow(hostAppJWT);
        } else if (!TextUtils.isEmpty((CharSequence)authKey)) {
            jsonBody = this.getBodyForIDPAuthCodeFlow(authKey, this.mLPAuthenticationParams.getHostAppRedirectUri());
        }
        LPLog.INSTANCE.d(TAG, "Idp json body: " + LPLog.INSTANCE.mask((Object)jsonBody));
        String idpUrl = String.format(IDP_URL, this.mIdpDomain, this.mBrandId, AUTHENTICATE);
        final HttpPostRequest httpPostRequest = new HttpPostRequest(idpUrl);
        LPJSONObjectBody body = new LPJSONObjectBody(jsonBody);
        httpPostRequest.setBody((HttpRequestBody)body);
        httpPostRequest.setCallback((ICallback)new ICallback<String, Exception>(){

            public void onSuccess(String idpResponse) {
                LPLog.INSTANCE.d(IdpRequest.TAG, "onSuccess " + LPLog.INSTANCE.mask((Object)idpResponse));
                if (!TextUtils.isEmpty((CharSequence)idpResponse)) {
                    try {
                        JSONObject idpJson = new JSONObject(idpResponse);
                        String token = idpJson.getString("token");
                        IdpRequest.this.mCallback.onSuccess(token);
                    }
                    catch (JSONException je) {
                        LPLog.INSTANCE.d(IdpRequest.TAG, "JSONException: ", (Throwable)je);
                        String errorMsg = "idp url = " + httpPostRequest.getUrl() + ". Exception " + je.getMessage();
                        IdpRequest.this.sendErrorCallback(new Exception(errorMsg));
                    }
                }
            }

            public void onError(Exception e) {
                LPLog.INSTANCE.d(IdpRequest.TAG, "Error: idp url = " + httpPostRequest.getUrl() + ". Exception ", (Throwable)e);
                IdpRequest.this.sendErrorCallback(e);
            }
        });
        return httpPostRequest;
    }

    @NonNull
    private JSONObject getBodyForIDPAuthCodeFlow(String authKey, String hostAppRedirectUri) {
        JSONObject jsonBody = new JSONObject();
        try {
            jsonBody.put("code", (Object)authKey);
            jsonBody.put("redirect_uri", (Object)(TextUtils.isEmpty((CharSequence)hostAppRedirectUri) ? DEFAULT_REDIRECT_URI : hostAppRedirectUri));
        }
        catch (JSONException e) {
            LPLog.INSTANCE.e(TAG, "JSON Exception while parsing body of IDP response for AuthCode Flow", (Throwable)e);
        }
        return jsonBody;
    }

    @NonNull
    protected JSONObject getBodyForIDPJwtFlow(String jwt) {
        JSONObject jsonBody = new JSONObject();
        try {
            jsonBody.put("id_token", (Object)jwt);
        }
        catch (JSONException e) {
            LPLog.INSTANCE.e(TAG, "JSON Exception while parsing body of IDP response for AuthCode Flow", (Throwable)e);
        }
        return jsonBody;
    }

    @NonNull
    private HttpPostRequest getHttpPostRequestForSignUp() {
        String IDP_URL = "https://%s/api/account/%s/%s?v=1.0";
        String idpUrl = String.format(IDP_URL, this.mIdpDomain, this.mBrandId, SIGNUP);
        final HttpPostRequest httpPostRequest = new HttpPostRequest(idpUrl);
        httpPostRequest.setCallback((ICallback)new ICallback<String, Exception>(){

            public void onSuccess(String idpResponse) {
                LPLog.INSTANCE.d(IdpRequest.TAG, "onSuccess " + LPLog.INSTANCE.mask((Object)idpResponse));
                if (!TextUtils.isEmpty((CharSequence)idpResponse)) {
                    try {
                        JSONObject idpJson = new JSONObject(idpResponse);
                        String token = idpJson.getString("jwt");
                        IdpRequest.this.mCallback.onSuccess(token);
                    }
                    catch (JSONException je) {
                        LPLog.INSTANCE.d(IdpRequest.TAG, "JSONException: ", (Throwable)je);
                        String errorMsg = "idp url = " + httpPostRequest.getUrl() + ". Exception " + je.getMessage();
                        IdpRequest.this.sendErrorCallback(new Exception(errorMsg));
                    }
                }
            }

            public void onError(Exception e) {
                LPLog.INSTANCE.d(IdpRequest.TAG, "Error: idp url = " + httpPostRequest.getUrl() + ". Exception ", (Throwable)e);
                IdpRequest.this.sendErrorCallback(e);
            }
        });
        return httpPostRequest;
    }

    private void addHeaders(HttpPostRequest httpPostRequest) {
        httpPostRequest.addHeader("sdkVersion", this.mHostVersion);
        httpPostRequest.addHeader("platform", "Android");
        httpPostRequest.addHeader("platformVer", String.valueOf(Build.VERSION.SDK_INT));
        httpPostRequest.addHeader("device", Build.MODEL);
        httpPostRequest.addHeader("applicationId", this.mBrandId.replace("\n", ""));
    }
}

