/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.utils;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.webkit.MimeTypeMap;
import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.background.filesharing.FileSharingType;

public class FileSharingUtils {
    private static final String TAG = "FileSharingUtils";

    @NonNull
    public static FileSharingType getFileSharingTypeFromUri(String uri, Context context) {
        try {
            Uri fileUri = Uri.parse((String)uri);
            String mimeType = context.getContentResolver().getType(fileUri);
            String extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType);
            if (extension != null) {
                return FileSharingType.getFileTypeFromExtension(extension);
            }
            return FileSharingType.UNKNOWN;
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, "Failed to get file sharing type.", (Throwable)e);
            return FileSharingType.UNKNOWN;
        }
    }

    public static boolean isDocumentType(FileSharingType fileType) {
        return fileType != null && fileType.getCommonFileType() == FileSharingType.CommonFileType.DOCUMENT;
    }
}

