package com.liveperson.api.response.events;


import android.text.TextUtils;

import com.liveperson.api.exception.BadConversationException;
import com.liveperson.api.response.AbstractResponse;
import com.liveperson.api.response.model.Change;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.network.socket.ExConversationChangeNotificationResponseHandler;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by oferd on 8/9/15.
 */
public class ExConversationChangeNotification extends AbstractResponse<ExConversationChangeNotification.Body> {

    public static final String CONVERSATION_CHANGE_NOTIFICATION_TYPE = "cqm.ExConversationChangeNotification";
    public Body notificationBody;

    public ExConversationChangeNotification(JSONObject obj) throws JSONException {
        super(obj);
        notificationBody = new Body(obj.getJSONObject("body"));
    }

    @Override
    public Body getBody() {
        return notificationBody;
    }

    public static class Body {
        private String subscriptionId;
        private Change[] changes;

        public Body(JSONObject obj) throws JSONException {
            subscriptionId = obj.optString("subscriptionId");
            if (TextUtils.isEmpty(subscriptionId)) {
                throw new JSONException("no subscription id");
            }
            JSONArray changesArr = obj.optJSONArray("changes");
            if (changesArr == null) {
                changesArr = new JSONArray();
            }
            changes = new Change[changesArr.length()];
            for (int i = 0; i < changes.length; i++) {
                try {
                    changes[i] = new Change(changesArr.getJSONObject(i));
                } catch (BadConversationException e) {
                    LPLog.INSTANCE.e(CONVERSATION_CHANGE_NOTIFICATION_TYPE, "Failed to parse JSON", e);
                }
            }
        }

        public String getSubscriptionId() {
            return subscriptionId;
        }

        public Change[] getChanges() {
            return changes;
        }
    }


    public static BaseResponseHandler getResponseHandler(Messaging messaging){
        return new ExConversationChangeNotificationResponseHandler(messaging);
    }
}
