package com.liveperson.api.response.types;

import android.text.TextUtils;

import com.liveperson.infra.log.LPLog;

/**
 * Created by oferd on 8/10/15.
 * Modified by Perry on 5/21/18.
 */
public enum CloseReason {
    CONSUMER, AGENT, SYSTEM, TIMEOUT; // The 'TIMEOUT' is no longer in use...

    private static final String TAG = "CloseReason";

    public static CloseReason parse(int ordinal) {
        CloseReason result = SYSTEM;

        CloseReason[] values = CloseReason.values();
        if (ordinal < values.length) {
            result = values[ordinal];
        }

        return result;
    }

    public static CloseReason parse(String closeReasonString) {
        CloseReason result = SYSTEM;
        if (TextUtils.isEmpty(closeReasonString)) return result;

        try {
            result = CloseReason.valueOf(closeReasonString);
        } catch (Exception e) {
            LPLog.INSTANCE.e(TAG, "Failed to parse CloseReason from string: " + closeReasonString, e);
            CloseReason[] values = values();
            for (CloseReason closeReason : values) {
                if (closeReason.name().equalsIgnoreCase(closeReasonString)) {
                    result = closeReason;
                    break;
                }
            }
        }

        return result;
    }
}
