package com.liveperson.messaging.background.filesharing.voice;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.webkit.MimeTypeMap;

import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.utils.ImageUtils;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.filesharing.BaseUploadTask;
import com.liveperson.messaging.background.filesharing.UploadFileTaskBundle;
import com.liveperson.messaging.commands.SendVoiceCommand;
import com.liveperson.messaging.exception.FileSharingException;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import static com.liveperson.infra.utils.Utils.getResources;

public class UploadVoiceTask extends BaseUploadTask{

	private static final String TAG = "UploadVoiceTask";

	protected UploadFileTaskBundle uploadFileTaskBundle;

	private String previewBase64;
	protected String previewContentType;

	public UploadVoiceTask(UploadFileTaskBundle params, Integer uploadTimeout) throws FileSharingException{

		super(uploadTimeout);

		if(params == null){
			throw new FileSharingException("Params is null");
		}

		uploadFileTaskBundle = params;

		// Get byte array of the voice file
		File file = new File(uploadFileTaskBundle.getFilePath());
		int size = (int) file.length();
		byte[] bytes = new byte[size];

		try {
			BufferedInputStream buf = new BufferedInputStream(new FileInputStream(file));
			//noinspection ResultOfMethodCallIgnored
			buf.read(bytes, 0, bytes.length);
			buf.close();
			mOriginalFileByteArray = bytes;
		} catch (IOException e) {
			LPLog.INSTANCE.e(TAG, "UploadVoiceTask: cannot extract file byteArray. Aborting upload file", e);
			return;
		}

		generatePreviewImage();

		createSendMessageCommand(null, params.getFilePath());
	}

	protected void createSendMessageCommand(String thumbnailPath, String filePath) {
		sendMessageCommand = new SendVoiceCommand(MessagingFactory.getInstance().getController(), uploadFileTaskBundle.getTargetId(), uploadFileTaskBundle.getBrandId(),
				uploadFileTaskBundle.getFileContentType(), thumbnailPath, filePath, uploadFileTaskBundle.getFileTypeExtension(), uploadFileTaskBundle.getMessage(), previewContentType);

		setSendMessageCommandCallback();
	}

	private void generatePreviewImage() {

		Bitmap bitmap = BitmapFactory.decodeResource(getResources(), R.drawable.lp_messaging_dummy_file_thumbnal);
		previewBase64 = ImageUtils.bitmapToBase64(bitmap);

		previewContentType = MimeTypeMap.getSingleton().getMimeTypeFromExtension("png");
	}

	@Override
	protected UploadFileTaskBundle getUploadTaskBundle() {

		return uploadFileTaskBundle;
	}

	@Override
	protected byte[] getFileByteArray() {
		return mOriginalFileByteArray;
	}

	@Override
	public int getTaskId() {
		return uploadFileTaskBundle.getTaskId();
	}

	@Override
	public String getThumbnailBase64() {

		return previewBase64;
	}
}
